/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.init;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfigData;
import com.tiviacz.travelersbackpack.inventory.SettingsManager;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.screen.TravelersBackpackBlockEntityScreenHandler;
import com.tiviacz.travelersbackpack.inventory.screen.TravelersBackpackItemScreenHandler;
import com.tiviacz.travelersbackpack.inventory.sorter.SlotManager;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class ModNetwork {
    public static final class_2960 EQUIP_BACKPACK_ID = new class_2960("travelersbackpack", "equip_backpack");
    public static final class_2960 DEPLOY_SLEEPING_BAG_ID = new class_2960("travelersbackpack", "deploy_sleeping_bag");
    public static final class_2960 SPECIAL_ACTION_ID = new class_2960("travelersbackpack", "special_action");
    public static final class_2960 ABILITY_SLIDER_ID = new class_2960("travelersbackpack", "ability_slider");
    public static final class_2960 SORTER_ID = new class_2960("travelersbackpack", "sorter");
    public static final class_2960 SLOT_ID = new class_2960("travelersbackpack", "slot");
    public static final class_2960 MEMORY_ID = new class_2960("travelersbackpack", "memory");
    public static final class_2960 SETTINGS_ID = new class_2960("travelersbackpack", "settings");
    public static final class_2960 UPDATE_CONFIG_ID = new class_2960("travelersbackpack", "update_config");
    public static final class_2960 SYNC_BACKPACK_ID = new class_2960("travelersbackpack", "sync_backpack");
    public static final class_2960 SEND_MESSAGE_ID = new class_2960("travelersbackpack", "send_message");

    public static void initClient() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)UPDATE_CONFIG_ID, (client, handler, buf, sender) -> {
            class_2487 tag = buf.method_10798();
            client.execute(() -> {
                TravelersBackpack.LOGGER.info("Syncing config from server to client...");
                AutoConfig.getConfigHolder(TravelersBackpackConfigData.class).setConfig((ConfigData)TravelersBackpackConfig.readFromNbt(tag));
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SYNC_BACKPACK_ID, (client, handler, buf, sender) -> {
            int entityId = buf.readInt();
            class_2487 compound = buf.method_10798();
            client.execute(() -> {
                class_1297 entity;
                if (client.field_1687 != null && (entity = client.field_1687.method_8469(entityId)) instanceof class_1657) {
                    class_1657 player = (class_1657)entity;
                    ComponentUtils.getComponent(player).setWearable(class_1799.method_7915((class_2487)compound));
                    ComponentUtils.getComponent(player).setContents(class_1799.method_7915((class_2487)compound));
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SEND_MESSAGE_ID, (client, handler, buf, sender) -> {
            boolean drop = buf.readBoolean();
            class_2338 pos = buf.method_10811();
            if (TravelersBackpackConfig.getConfig().client.sendBackpackCoordinatesMessage && class_310.method_1551().field_1724 != null) {
                class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43469((String)(drop ? "information.travelersbackpack.backpack_drop" : "information.travelersbackpack.backpack_coords"), (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}));
            }
        });
    }

    public static void initServer() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            TravelersBackpack.LOGGER.info("Loading config from file...");
            AutoConfig.getConfigHolder(TravelersBackpackConfigData.class).load();
            class_2540 data = PacketByteBufs.create();
            data.method_10794(TravelersBackpackConfig.writeToNbt());
            ServerPlayNetworking.send((class_3222)handler.field_14140, (class_2960)UPDATE_CONFIG_ID, (class_2540)data);
            class_2540 buf2 = PacketByteBufs.create();
            buf2.writeInt(handler.method_32311().method_5628());
            buf2.method_10794(ComponentUtils.getWearingBackpack((class_1657)handler.method_32311()).method_7953(new class_2487()));
            sender.sendPacket(SYNC_BACKPACK_ID, buf2);
            for (class_3222 serverPlayer : PlayerLookup.around((class_3218)handler.method_32311().method_14220(), (class_243)handler.method_32311().method_19538(), (double)64.0)) {
                class_2540 buf3 = PacketByteBufs.create();
                buf3.writeInt(serverPlayer.method_5628());
                buf3.method_10794(ComponentUtils.getWearingBackpack((class_1657)serverPlayer).method_7953(new class_2487()));
                sender.sendPacket(SYNC_BACKPACK_ID, buf3);
            }
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)EQUIP_BACKPACK_ID, (server, player, handler, buf, response) -> {
            boolean equip = buf.readBoolean();
            server.execute(() -> {
                if (player != null) {
                    if (equip) {
                        if (!ComponentUtils.isWearingBackpack((class_1657)player)) {
                            ServerActions.equipBackpack((class_1657)player);
                        } else {
                            player.method_14247();
                            player.method_7353((class_2561)class_2561.method_43471((String)"action.travelersbackpack.equip_otherbackpack"), false);
                        }
                    } else if (ComponentUtils.isWearingBackpack((class_1657)player)) {
                        ServerActions.unequipBackpack((class_1657)player);
                    } else {
                        player.method_14247();
                        player.method_7353((class_2561)class_2561.method_43471((String)"action.travelersbackpack.unequip_nobackpack"), false);
                    }
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)DEPLOY_SLEEPING_BAG_ID, (server, player, handler, buf, response) -> {
            class_2338 pos = buf.method_10811();
            server.execute(() -> {
                if (player != null) {
                    ServerActions.toggleSleepingBag((class_1657)player, pos);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SPECIAL_ACTION_ID, (server, player, handler, buf, response) -> {
            byte screenID = buf.readByte();
            byte typeOfAction = buf.readByte();
            double scrollDelta = buf.readDouble();
            server.execute(() -> {
                if (player != null) {
                    if (typeOfAction == 0) {
                        ServerActions.swapTool((class_1657)player, scrollDelta);
                    } else if (typeOfAction == 1) {
                        ServerActions.switchHoseMode((class_1657)player, scrollDelta);
                    } else if (typeOfAction == 2) {
                        ServerActions.toggleHoseTank((class_1657)player);
                    } else if (typeOfAction == 3) {
                        ServerActions.emptyTank(scrollDelta, (class_1657)player, player.field_6002, screenID);
                    } else if (typeOfAction == 4 && ComponentUtils.isWearingBackpack((class_1657)player)) {
                        TravelersBackpackInventory.openHandledScreen((class_1657)player, ComponentUtils.getWearingBackpack((class_1657)player), (byte)2);
                    }
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ABILITY_SLIDER_ID, (server, player, handler, buf, response) -> {
            byte screenID = buf.readByte();
            boolean sliderValue = buf.readBoolean();
            server.execute(() -> {
                if (player != null) {
                    if (screenID == 2 && ComponentUtils.isWearingBackpack((class_1657)player)) {
                        ServerActions.switchAbilitySlider((class_1657)player, sliderValue);
                    } else if (screenID == 3 && player.field_7512 instanceof TravelersBackpackBlockEntityScreenHandler) {
                        ServerActions.switchAbilitySliderBlockEntity((class_1657)player, ((TravelersBackpackBlockEntityScreenHandler)player.field_7512).inventory.getPosition(), sliderValue);
                    }
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SORTER_ID, (server, player, handler, buf, response) -> {
            byte screenID = buf.readByte();
            byte button = buf.readByte();
            boolean shiftPressed = buf.readBoolean();
            server.execute(() -> {
                if (player != null) {
                    ServerActions.sortBackpack((class_1657)player, screenID, button, shiftPressed);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SLOT_ID, (server, player, handler, buf, response) -> {
            byte screenID = buf.readByte();
            boolean isActive = buf.readBoolean();
            int[] selectedSlots = buf.method_10787();
            server.execute(() -> {
                if (player != null) {
                    SlotManager manager;
                    if (screenID == 2) {
                        manager = ComponentUtils.getBackpackInv((class_1657)player).getSlotManager();
                        manager.setSelectorActive((byte)0, isActive);
                        manager.setUnsortableSlots(selectedSlots, true);
                        manager.setSelectorActive((byte)0, !isActive);
                    }
                    if (screenID == 1) {
                        manager = ((TravelersBackpackItemScreenHandler)player.field_7512).inventory.getSlotManager();
                        manager.setSelectorActive((byte)0, isActive);
                        manager.setUnsortableSlots(selectedSlots, true);
                        manager.setSelectorActive((byte)0, !isActive);
                    }
                    if (screenID == 3) {
                        manager = ((TravelersBackpackBlockEntityScreenHandler)player.field_7512).inventory.getSlotManager();
                        manager.setSelectorActive((byte)0, isActive);
                        manager.setUnsortableSlots(selectedSlots, true);
                        manager.setSelectorActive((byte)0, !isActive);
                    }
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)MEMORY_ID, (server, player, handler, buf, response) -> {
            byte screenID = buf.readByte();
            boolean isActive = buf.readBoolean();
            int[] selectedSlots = buf.method_10787();
            class_1799[] stacks = new class_1799[selectedSlots.length];
            for (int i = 0; i < selectedSlots.length; ++i) {
                stacks[i] = buf.method_10819();
            }
            server.execute(() -> {
                if (player != null) {
                    SlotManager manager;
                    if (screenID == 2) {
                        manager = ComponentUtils.getBackpackInv((class_1657)player).getSlotManager();
                        manager.setSelectorActive((byte)1, isActive);
                        manager.setMemorySlots(selectedSlots, stacks, true);
                        manager.setSelectorActive((byte)1, !isActive);
                    }
                    if (screenID == 1) {
                        manager = ((TravelersBackpackItemScreenHandler)player.field_7512).inventory.getSlotManager();
                        manager.setSelectorActive((byte)1, isActive);
                        manager.setMemorySlots(selectedSlots, stacks, true);
                        manager.setSelectorActive((byte)1, !isActive);
                    }
                    if (screenID == 3) {
                        manager = ((TravelersBackpackBlockEntityScreenHandler)player.field_7512).inventory.getSlotManager();
                        manager.setSelectorActive((byte)1, isActive);
                        manager.setMemorySlots(selectedSlots, stacks, true);
                        manager.setSelectorActive((byte)1, !isActive);
                    }
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SETTINGS_ID, (server, player, handler, buf, response) -> {
            byte screenID = buf.readByte();
            byte dataArray = buf.readByte();
            int place = buf.readInt();
            byte value = buf.readByte();
            server.execute(() -> {
                if (player != null) {
                    SettingsManager manager;
                    if (screenID == 2) {
                        manager = ComponentUtils.getBackpackInv((class_1657)player).getSettingsManager();
                        manager.set(dataArray, place, value);
                    }
                    if (screenID == 1) {
                        manager = ((TravelersBackpackItemScreenHandler)player.field_7512).inventory.getSettingsManager();
                        manager.set(dataArray, place, value);
                    }
                    if (screenID == 3) {
                        manager = ((TravelersBackpackBlockEntityScreenHandler)player.field_7512).inventory.getSettingsManager();
                        manager.set(dataArray, place, value);
                    }
                }
            });
        });
    }
}

