/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.fluids;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.tiviacz.travelersbackpack.fluids.EffectFluid;
import com.tiviacz.travelersbackpack.fluids.effects.LavaEffect;
import com.tiviacz.travelersbackpack.fluids.effects.MilkEffect;
import com.tiviacz.travelersbackpack.fluids.effects.PotionEffect;
import com.tiviacz.travelersbackpack.fluids.effects.WaterEffect;
import com.tiviacz.travelersbackpack.init.ModFluids;
import com.tiviacz.travelersbackpack.util.LogHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_3611;

public class EffectFluidRegistry {
    public static BiMap<String, EffectFluid> EFFECT_REGISTRY = HashBiMap.create();
    public static EffectFluid WATER_EFFECT;
    public static EffectFluid LAVA_EFFECT;
    public static EffectFluid POTION_EFFECT;
    public static EffectFluid MILK_EFFECT;
    public static EffectFluid CREATE_POTION_EFFECT;
    private static int effectIDCounter;

    public static void initEffects() {
        EFFECT_REGISTRY.clear();
        WATER_EFFECT = new WaterEffect();
        LAVA_EFFECT = new LavaEffect();
        POTION_EFFECT = new PotionEffect("travelersbackpack:potion", (class_3611)ModFluids.POTION_STILL);
        MILK_EFFECT = new MilkEffect();
        if (EffectFluidRegistry.canInitialize("create")) {
            CREATE_POTION_EFFECT = new PotionEffect("create:potion", "create", "potion");
        }
    }

    public static int registerFluidEffect(EffectFluid effect) {
        String uniqueId = effect.getUniqueId();
        if (!EFFECT_REGISTRY.containsKey((Object)uniqueId) && effect.fluid != null) {
            EFFECT_REGISTRY.put((Object)uniqueId, (Object)effect);
            effect.setEffectID(effectIDCounter);
            LogHelper.info("Registered the FluidEffect with Unique ID of " + uniqueId + " for " + class_2378.field_11154.method_10221((Object)effect.fluid) + " " + effect.amountRequired + " with the ID " + effectIDCounter, new Object[0]);
            return ++effectIDCounter;
        }
        return -1;
    }

    public static Map<String, EffectFluid> getRegisteredFluidEffects() {
        return ImmutableMap.copyOf(EFFECT_REGISTRY);
    }

    public static long getHighestFluidEffectAmount(class_3611 fluid) {
        long amount = 0L;
        for (EffectFluid effect : EffectFluidRegistry.getEffectsForFluid(fluid)) {
            if (effect.amountRequired <= amount) continue;
            amount = effect.amountRequired;
        }
        return amount;
    }

    public static ArrayList<EffectFluid> getEffectsForFluid(class_3611 fluid) {
        ArrayList<EffectFluid> effectsForFluid = new ArrayList<EffectFluid>();
        for (EffectFluid effect : EffectFluidRegistry.getRegisteredFluidEffects().values()) {
            if (fluid != effect.fluid) continue;
            effectsForFluid.add(effect);
        }
        return effectsForFluid;
    }

    public static boolean hasEffects(class_3611 fluid) {
        ArrayList<EffectFluid> effects = EffectFluidRegistry.getEffectsForFluid(fluid);
        return !effects.isEmpty();
    }

    public static boolean hasExecutableEffects(SingleVariantStorage<FluidVariant> storage, class_1937 world, class_1297 entity) {
        List<EffectFluid> executableEffects = EffectFluidRegistry.getExecutableEffects(storage, world, entity);
        return !executableEffects.isEmpty();
    }

    public static List<EffectFluid> getExecutableEffects(SingleVariantStorage<FluidVariant> storage, class_1937 world, class_1297 entity) {
        ArrayList<EffectFluid> executableEffects = new ArrayList<EffectFluid>();
        for (EffectFluid effect : EffectFluidRegistry.getEffectsForFluid(((FluidVariant)storage.getResource()).getFluid())) {
            if (!effect.canExecuteEffect((StorageView<FluidVariant>)storage, world, entity)) continue;
            executableEffects.add(effect);
        }
        return executableEffects;
    }

    public static boolean executeEffects(SingleVariantStorage<FluidVariant> storage, class_1297 entity, class_1937 world) {
        for (EffectFluid effect : EffectFluidRegistry.getExecutableEffects(storage, world, entity)) {
            effect.affectDrinker((StorageView<FluidVariant>)storage, world, entity);
        }
        return true;
    }

    public static boolean canInitialize(String modid) {
        return FabricLoader.getInstance().isModLoaded(modid);
    }

    static {
        effectIDCounter = 0;
    }
}

