/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tiviacz.travelersbackpack.init.ModRecipeSerializers;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2378;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class ShapedBackpackRecipeJsonBuilder
implements class_5797 {
    private final class_1792 output;
    private final int outputCount;
    private final List<String> pattern = Lists.newArrayList();
    private final Map<Character, class_1856> inputs = Maps.newLinkedHashMap();
    private final class_161.class_162 advancementBuilder = class_161.class_162.method_707();
    @Nullable
    private String group;

    public ShapedBackpackRecipeJsonBuilder(class_1935 output, int outputCount) {
        this.output = output.method_8389();
        this.outputCount = outputCount;
    }

    public static ShapedBackpackRecipeJsonBuilder create(class_1935 output) {
        return ShapedBackpackRecipeJsonBuilder.create(output, 1);
    }

    public static ShapedBackpackRecipeJsonBuilder create(class_1935 output, int outputCount) {
        return new ShapedBackpackRecipeJsonBuilder(output, outputCount);
    }

    public ShapedBackpackRecipeJsonBuilder input(Character c, class_6862<class_1792> tag) {
        return this.input(c, class_1856.method_8106(tag));
    }

    public ShapedBackpackRecipeJsonBuilder input(Character c, class_1935 itemProvider) {
        return this.input(c, class_1856.method_8091((class_1935[])new class_1935[]{itemProvider}));
    }

    public ShapedBackpackRecipeJsonBuilder input(Character c, class_1856 ingredient) {
        if (this.inputs.containsKey(c)) {
            throw new IllegalArgumentException("Symbol '" + c + "' is already defined!");
        }
        if (c.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.inputs.put(c, ingredient);
        return this;
    }

    public ShapedBackpackRecipeJsonBuilder pattern(String patternStr) {
        if (!this.pattern.isEmpty() && patternStr.length() != this.pattern.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.pattern.add(patternStr);
        return this;
    }

    public ShapedBackpackRecipeJsonBuilder criterion(String string, class_184 criterionConditions) {
        this.advancementBuilder.method_709(string, criterionConditions);
        return this;
    }

    public ShapedBackpackRecipeJsonBuilder group(@Nullable String string) {
        this.group = string;
        return this;
    }

    public class_1792 method_36441() {
        return this.output;
    }

    public void method_17972(Consumer<class_2444> exporter, class_2960 recipeId) {
        this.validate(recipeId);
        this.advancementBuilder.method_708(field_39377).method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)recipeId)).method_703(class_170.class_171.method_753((class_2960)recipeId)).method_704(class_193.field_1257);
        exporter.accept(new ShapedBackpackRecipeJsonProvider(recipeId, this.output, this.outputCount, this.group == null ? "" : this.group, this.pattern, this.inputs, this.advancementBuilder, new class_2960(recipeId.method_12836(), "recipes/" + this.output.method_7859().method_7751() + "/" + recipeId.method_12832())));
    }

    private void validate(class_2960 recipeId) {
        if (this.pattern.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + recipeId + "!");
        }
        HashSet set = Sets.newHashSet(this.inputs.keySet());
        set.remove(Character.valueOf(' '));
        for (String string : this.pattern) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (!this.inputs.containsKey(Character.valueOf(c)) && c != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + recipeId + " uses undefined symbol '" + c + "'");
                }
                set.remove(Character.valueOf(c));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + recipeId);
        }
        if (this.pattern.size() == 1 && this.pattern.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + recipeId + " only takes in a single item - should it be a shapeless recipe instead?");
        }
        if (this.advancementBuilder.method_710().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + recipeId);
        }
    }

    static class ShapedBackpackRecipeJsonProvider
    implements class_2444 {
        private final class_2960 recipeId;
        private final class_1792 output;
        private final int resultCount;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, class_1856> inputs;
        private final class_161.class_162 advancementBuilder;
        private final class_2960 advancementId;

        public ShapedBackpackRecipeJsonProvider(class_2960 recipeId, class_1792 output, int resultCount, String group, List<String> pattern, Map<Character, class_1856> inputs, class_161.class_162 advancementBuilder, class_2960 advancementId) {
            this.recipeId = recipeId;
            this.output = output;
            this.resultCount = resultCount;
            this.group = group;
            this.pattern = pattern;
            this.inputs = inputs;
            this.advancementBuilder = advancementBuilder;
            this.advancementId = advancementId;
        }

        public void method_10416(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray jsonArray = new JsonArray();
            for (String string : this.pattern) {
                jsonArray.add(string);
            }
            json.add("pattern", (JsonElement)jsonArray);
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry<Character, class_1856> entry : this.inputs.entrySet()) {
                jsonObject.add(String.valueOf(entry.getKey()), entry.getValue().method_8089());
            }
            json.add("key", (JsonElement)jsonObject);
            JsonObject jsonObject2 = new JsonObject();
            jsonObject2.addProperty("item", class_2378.field_11142.method_10221((Object)this.output).toString());
            if (this.resultCount > 1) {
                jsonObject2.addProperty("count", (Number)this.resultCount);
            }
            json.add("result", (JsonElement)jsonObject2);
        }

        public class_1865<?> method_17800() {
            return ModRecipeSerializers.BACKPACK_SHAPED;
        }

        public class_2960 method_10417() {
            return this.recipeId;
        }

        @Nullable
        public JsonObject method_10415() {
            return this.advancementBuilder.method_698();
        }

        @Nullable
        public class_2960 method_10418() {
            return this.advancementId;
        }
    }
}

