/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tiviacz.travelersbackpack.client.screen.TravelersBackpackHandledScreen;
import com.tiviacz.travelersbackpack.client.screen.widget.WidgetBase;
import com.tiviacz.travelersbackpack.compat.craftingtweaks.ICraftingTweaks;
import com.tiviacz.travelersbackpack.compat.craftingtweaks.TravelersBackpackCraftingGridAddition;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModNetwork;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class CraftingWidget
extends WidgetBase {
    private static ICraftingTweaks craftingTweaksAddition = ICraftingTweaks.EMPTY;

    public CraftingWidget(TravelersBackpackHandledScreen screen, int x, int y, int width, int height) {
        super(screen, x, y, width, height);
        this.isVisible = screen.inventory.getSettingsManager().hasCraftingGrid();
        this.isWidgetActive = screen.inventory.getSettingsManager().showCraftingGrid();
        this.showTooltip = true;
        if (!screen.inventory.getSettingsManager().hasCraftingGrid()) {
            this.width = 0;
            this.height = 0;
        }
        craftingTweaksAddition.setScreen(screen);
        if (this.isWidgetActive) {
            this.height = 107;
            this.width = 66;
            if (this.isCraftingTweaksAdditionEnabled()) {
                this.width = 83;
            }
            craftingTweaksAddition.onCraftingSlotsDisplayed();
        } else {
            this.height = 18;
            this.width = 15;
        }
        this.zOffset = 0;
    }

    @Override
    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.zOffset != 0) {
            matrixStack.method_22903();
            matrixStack.method_22904(0.0, 0.0, (double)this.zOffset);
        }
        RenderSystem.enableDepthTest();
        this.drawBackground(matrixStack, class_310.method_1551(), mouseX, mouseY);
        if (this.zOffset != 0) {
            matrixStack.method_22909();
        }
    }

    @Override
    protected void drawBackground(class_4587 matrices, class_310 minecraft, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (class_2960)TravelersBackpackHandledScreen.SETTINGS_TRAVELERS_BACKPACK);
        if (this.isVisible()) {
            this.screen.method_25302(matrices, this.isWidgetActive ? this.x - 3 : this.x, this.y, this.isWidgetActive ? 29 : 48, this.isWidgetActive ? 41 : 0, this.width - (this.isCraftingTweaksAdditionEnabled() && this.isWidgetActive() ? 17 : 0), this.height);
            if (this.isWidgetActive()) {
                if (TravelersBackpackConfig.getConfig().client.enableLegacyGui) {
                    this.drawLegacyGridAndResult(matrices, this.x + 3, this.y + 17);
                }
                RenderSystem.setShaderTexture((int)0, (class_2960)TravelersBackpackHandledScreen.SETTINGS_TRAVELERS_BACKPACK);
                if (this.isCraftingTweaksAdditionEnabled()) {
                    this.screen.method_25302(matrices, this.x + 60, this.y, 96, 41, 20, 107);
                }
                if (this.screen.inventory.getSettingsManager().shiftClickToBackpack()) {
                    this.screen.method_25302(matrices, this.x + 6, this.y + 88, 16, 73, 10, 8);
                } else {
                    this.screen.method_25302(matrices, this.x + 7, this.y + 87, 3, 72, 8, 10);
                }
            }
        }
    }

    @Override
    public void drawMouseoverTooltip(class_4587 matrices, int mouseX, int mouseY) {
        if (this.isWidgetActive() && this.isVisible()) {
            class_310.method_1551().field_1772.method_30883(matrices, (class_2561)class_2561.method_43471((String)"container.crafting"), (float)(this.x + 13), (float)(this.y + 6), 0x404040);
        }
        if (this.method_25405(mouseX, mouseY) && this.showTooltip && this.isVisible) {
            if (!this.isWidgetActive()) {
                this.screen.method_25424(matrices, (class_2561)class_2561.method_43471((String)"screen.travelersbackpack.crafting"), mouseX, mouseY);
            } else {
                if (this.in(mouseX, mouseY, this.x, this.y + 3, 13, 11)) {
                    this.screen.method_25424(matrices, (class_2561)class_2561.method_43471((String)"screen.travelersbackpack.crafting"), mouseX, mouseY);
                }
                if (mouseX >= this.x + 6 && mouseY >= this.y + 87 && mouseX < this.x + 16 && mouseY < this.y + 97) {
                    if (this.screen.inventory.getSettingsManager().shiftClickToBackpack()) {
                        this.screen.method_25424(matrices, (class_2561)class_2561.method_43471((String)"screen.travelersbackpack.crafting_to_backpack"), mouseX, mouseY);
                    } else {
                        this.screen.method_25424(matrices, (class_2561)class_2561.method_43471((String)"screen.travelersbackpack.crafting_to_player"), mouseX, mouseY);
                    }
                }
            }
        }
    }

    @Override
    public void setWidgetStatus(boolean status) {
        boolean showCraftingWidget = this.screen.inventory.getSettingsManager().showCraftingGrid();
        this.screen.inventory.getSettingsManager().set((byte)0, 1, (byte)(!showCraftingWidget ? 1 : 0));
        class_2540 buf = PacketByteBufs.create();
        buf.writeByte((int)this.screen.inventory.getScreenID()).writeByte(0).writeInt(1).writeByte((int)((byte)(!showCraftingWidget ? 1 : 0)));
        ClientPlayNetworking.send((class_2960)ModNetwork.SETTINGS_ID, (class_2540)buf);
        super.setWidgetStatus(status);
    }

    @Override
    public boolean method_25405(double pMouseX, double pMouseY) {
        if (this.isWidgetActive()) {
            if (pMouseX >= (double)(this.x + 3) && pMouseY >= (double)(this.y + 16) && pMouseX < (double)(this.x + 57) && pMouseY < (double)(this.y + 70)) {
                return false;
            }
            if (pMouseX >= (double)(this.x + 21) && pMouseY >= (double)(this.y + 83) && pMouseX < (double)(this.x + 39) && pMouseY < (double)(this.y + 101)) {
                return false;
            }
        }
        return pMouseX >= (double)this.x && pMouseY >= (double)this.y && pMouseX < (double)(this.x + this.width) && pMouseY < (double)(this.y + this.height);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.screen.settingsWidget.isWidgetActive()) {
            return false;
        }
        if (!this.isVisible()) {
            return false;
        }
        if (this.isWidgetActive() && this.isCraftingTweaksAdditionEnabled()) {
            if (mouseX >= (double)(this.x + 59) && mouseY >= (double)(this.y + 18) && mouseX < (double)(this.x + 75) && mouseY < (double)(this.y + 34)) {
                return false;
            }
            if (mouseX >= (double)(this.x + 59) && mouseY >= (double)(this.y + 36) && mouseX < (double)(this.x + 75) && mouseY < (double)(this.y + 52)) {
                return false;
            }
            if (mouseX >= (double)(this.x + 59) && mouseY >= (double)(this.y + 54) && mouseX < (double)(this.x + 75) && mouseY < (double)(this.y + 70)) {
                return false;
            }
        }
        if (this.method_25405(mouseX, mouseY)) {
            if (this.isWidgetActive) {
                if (mouseX >= (double)this.x && mouseY >= (double)(this.y + 3) && mouseX < (double)(this.x + 13) && mouseY < (double)(this.y + 15)) {
                    this.setWidgetStatus(false);
                    craftingTweaksAddition.onCraftingSlotsHidden();
                    this.screen.playUIClickSound();
                }
                if (mouseX >= (double)(this.x + 6) && mouseY >= (double)(this.y + 87) && mouseX < (double)(this.x + 16) && mouseY < (double)(this.y + 97)) {
                    boolean shiftClickToBackpack = this.screen.inventory.getSettingsManager().shiftClickToBackpack();
                    this.screen.inventory.getSettingsManager().set((byte)0, 2, (byte)(!shiftClickToBackpack ? 1 : 0));
                    class_2540 buf = PacketByteBufs.create();
                    buf.writeByte((int)this.screen.inventory.getScreenID()).writeByte(0).writeInt(2).writeByte((int)((byte)(!shiftClickToBackpack ? 1 : 0)));
                    ClientPlayNetworking.send((class_2960)ModNetwork.SETTINGS_ID, (class_2540)buf);
                    this.screen.playUIClickSound();
                }
            } else {
                this.setWidgetStatus(true);
                craftingTweaksAddition.onCraftingSlotsDisplayed();
                this.screen.playUIClickSound();
            }
            if (this.isWidgetActive) {
                this.height = 107;
                this.width = 66;
                if (this.isCraftingTweaksAdditionEnabled()) {
                    this.width = 83;
                }
                this.zOffset = 0;
            }
            if (!this.isWidgetActive) {
                this.height = 18;
                this.width = 15;
                this.zOffset = 0;
            }
            return true;
        }
        return false;
    }

    public void drawLegacyGridAndResult(class_4587 matrices, int x, int y) {
        RenderSystem.setShaderTexture((int)0, (class_2960)TravelersBackpackHandledScreen.EXTRAS_TRAVELERS_BACKPACK);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.screen.drawSlotLegacy(matrices, x + i * 18, y + j * 18, 213, 19);
            }
        }
        this.screen.drawSlotLegacy(matrices, x + 18, y + 66, 213, 19);
    }

    public static void setCraftingTweaksAddition(ICraftingTweaks addition) {
        craftingTweaksAddition = addition;
    }

    public ICraftingTweaks getCraftingTweaksAddition() {
        return craftingTweaksAddition;
    }

    public boolean isCraftingTweaksAdditionEnabled() {
        if (!this.screen.inventory.getSettingsManager().hasCraftingGrid()) {
            return false;
        }
        return craftingTweaksAddition instanceof TravelersBackpackCraftingGridAddition;
    }

    @Override
    public boolean isSettingsChild() {
        return false;
    }

    @Override
    public int[] getWidgetSizeAndPos() {
        int[] size = new int[]{this.x, this.y, this.width, this.height};
        return size;
    }
}

