/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.stateobserver.api;

import com.favouriteless.stateobserver.api.StateChangeSet;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public abstract class StateObserver {
    private final StateChangeSet changeSet = new StateChangeSet();
    private final class_1937 level;
    private final class_2338 pos;
    private final int radiusX;
    private final int radiusY;
    private final int radiusZ;

    public StateObserver(class_1937 level, class_2338 pos, int radiusX, int radiusY, int radiusZ) {
        this.level = level;
        this.pos = pos;
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.radiusZ = radiusZ;
        if (radiusX <= 0) {
            throw new IllegalStateException("StateObserver's X radius must be greater than Zero");
        }
        if (radiusY <= 0) {
            throw new IllegalStateException("StateObserver's Y radius must be greater than Zero");
        }
        if (radiusZ <= 0) {
            throw new IllegalStateException("StateObserver's Z radius must be greater than Zero");
        }
    }

    protected abstract void handleChanges();

    public abstract void onInit();

    public abstract void onRemove();

    public void checkChanges() {
        if (!this.changeSet.getChanges().isEmpty()) {
            this.handleChanges();
            this.changeSet.clear();
        }
    }

    public boolean isWithinBounds(class_2338 pos) {
        return pos.method_10263() >= this.pos.method_10263() - this.radiusX && pos.method_10263() <= this.pos.method_10263() + this.radiusX && pos.method_10264() >= this.pos.method_10264() - this.radiusY && pos.method_10264() <= this.pos.method_10264() + this.radiusY && pos.method_10260() >= this.pos.method_10260() - this.radiusZ && pos.method_10260() <= this.pos.method_10260() + this.radiusZ;
    }

    public StateChangeSet getStateChangeSet() {
        return this.changeSet;
    }

    public class_1937 getLevel() {
        return this.level;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public int getRadiusX() {
        return this.radiusX;
    }

    public int getRadiusY() {
        return this.radiusY;
    }

    public int getRadiusZ() {
        return this.radiusZ;
    }
}

