/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.stateobserver;

import com.favouriteless.stateobserver.api.StateObserver;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class StateObserverManager {
    private static final List<StateObserver> OBSERVERS = new ArrayList<StateObserver>();

    public static <T extends StateObserver> T createObserver(T observer) {
        OBSERVERS.add(observer);
        observer.onInit();
        return observer;
    }

    public static void removeObserver(StateObserver observer) {
        observer.onRemove();
        OBSERVERS.remove(observer);
    }

    public static void notifyChange(class_1937 level, class_2338 pos, class_2680 oldState, class_2680 newState) {
        for (StateObserver observer : OBSERVERS) {
            if (level != observer.getLevel() || !observer.isWithinBounds(pos)) continue;
            observer.getStateChangeSet().change(pos, oldState, newState);
        }
    }

    public static <T extends StateObserver> T getObserver(class_1937 level, class_2338 pos, Class<T> clazz) {
        for (StateObserver observer : OBSERVERS) {
            if (observer.getClass() != clazz || observer.getLevel() != level || !observer.getPos().equals((Object)pos)) continue;
            return (T)observer;
        }
        return null;
    }

    public static void reset() {
        OBSERVERS.clear();
    }
}

