/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public final class EntityRetrievalUtil {
    @Nullable
    public static <T extends class_1297> T getNearest(class_243 origin, List<T> entities) {
        if (entities.isEmpty()) {
            return null;
        }
        double dist = Double.MAX_VALUE;
        class_1297 closest = null;
        for (class_1297 entity : entities) {
            double entityDist = entity.method_5707(origin);
            if (!(entityDist < dist)) continue;
            dist = entityDist;
            closest = entity;
        }
        return (T)closest;
    }

    @Nullable
    public static <T extends class_1297> T getNearestEntity(class_1297 origin, double radius, Predicate<? extends class_1297> predicate) {
        return EntityRetrievalUtil.getNearestEntity(origin, radius, radius, radius, predicate);
    }

    @Nullable
    public static <T extends class_1297> T getNearestEntity(class_1297 origin, double radiusX, double radiusY, double radiusZ, Predicate<? extends class_1297> predicate) {
        return EntityRetrievalUtil.getNearestEntity(origin.field_6002, new class_238(origin.method_23317() - radiusX, origin.method_23318() - radiusY, origin.method_23321() - radiusZ, origin.method_23317() + radiusX, origin.method_23318() + radiusY, origin.method_23321() + radiusZ), origin.method_19538(), predicate);
    }

    @Nullable
    public static <T extends class_1297> T getNearestEntity(class_1937 level, class_238 area, class_243 origin, Predicate<? extends class_1297> predicate) {
        Predicate<? extends class_1297> typeSafePredicate = predicate;
        MutableDouble dist = new MutableDouble(Double.MAX_VALUE);
        MutableObject closest = new MutableObject(null);
        level.method_31592().method_31807(area, entity -> {
            double entityDist;
            if (typeSafePredicate.test((class_1297)entity) && (entityDist = entity.method_5707(origin)) < dist.getValue()) {
                dist.setValue(entityDist);
                closest.setValue(entity);
            }
        });
        return (T)((class_1297)closest.getValue());
    }

    @Nullable
    public static class_1657 getNearestPlayer(class_1297 origin, double radius, Predicate<class_1657> predicate) {
        return EntityRetrievalUtil.getNearestPlayer(origin, radius, radius, radius, predicate);
    }

    @Nullable
    public static class_1657 getNearestPlayer(class_1297 origin, double radiusX, double radiusY, double radiusZ, Predicate<class_1657> predicate) {
        return EntityRetrievalUtil.getNearestPlayer(origin.field_6002, new class_238(origin.method_23317() - radiusX, origin.method_23318() - radiusY, origin.method_23321() - radiusZ, origin.method_23317() + radiusX, origin.method_23318() + radiusY, origin.method_23321() + radiusZ), origin.method_19538(), predicate);
    }

    @Nullable
    public static class_1657 getNearestPlayer(class_1937 level, class_238 area, class_243 origin, Predicate<class_1657> predicate) {
        double dist = Double.MAX_VALUE;
        class_1657 closest = null;
        for (class_1657 player : level.method_18456()) {
            double playerDist;
            if (!area.method_1006(player.method_19538()) || !predicate.test(player) || !((playerDist = player.method_5707(origin)) < dist)) continue;
            dist = playerDist;
            closest = player;
        }
        return closest;
    }

    public static List<class_1657> getPlayers(class_1937 level, class_238 area) {
        return EntityRetrievalUtil.getPlayers(level, area, (class_1657 pl) -> true);
    }

    public static List<class_1657> getPlayers(class_1297 origin, double radius, Predicate<class_1657> predicate) {
        return EntityRetrievalUtil.getPlayers(origin, radius, radius, radius, predicate);
    }

    public static List<class_1657> getPlayers(class_1297 origin, double radiusX, double radiusY, double radiusZ, Predicate<class_1657> predicate) {
        return EntityRetrievalUtil.getPlayers(origin.field_6002, new class_238(origin.method_23317() - radiusX, origin.method_23318() - radiusY, origin.method_23321() - radiusZ, origin.method_23317() + radiusX, origin.method_23318() + radiusY, origin.method_23321() + radiusZ), predicate);
    }

    public static List<class_1657> getPlayers(class_1937 level, class_238 area, Predicate<class_1657> predicate) {
        ObjectArrayList players = new ObjectArrayList();
        for (class_1657 player : level.method_18456()) {
            if (!area.method_1006(player.method_19538()) || !predicate.test(player)) continue;
            players.add(player);
        }
        return players;
    }

    public static <T> List<T> getEntities(class_1297 origin, double radius, Predicate<? extends class_1297> predicate) {
        return EntityRetrievalUtil.getEntities(origin, radius, radius, radius, predicate);
    }

    public static <T> List<T> getEntities(class_1297 origin, double radiusX, double radiusY, double radiusZ, Predicate<? extends class_1297> predicate) {
        return EntityRetrievalUtil.getEntities(origin.field_6002, new class_238(origin.method_23317() - radiusX, origin.method_23318() - radiusY, origin.method_23321() - radiusZ, origin.method_23317() + radiusX, origin.method_23318() + radiusY, origin.method_23321() + radiusZ), predicate.and(entity -> entity != origin));
    }

    public static <T> List<T> getEntities(class_1937 level, class_238 area, Predicate<? extends class_1297> predicate) {
        Predicate<? extends class_1297> typeSafePredicate = predicate;
        ObjectArrayList entities = new ObjectArrayList();
        level.method_31592().method_31807(area, arg_0 -> EntityRetrievalUtil.lambda$getEntities$3(typeSafePredicate, (List)entities, arg_0));
        return entities;
    }

    private static /* synthetic */ void lambda$getEntities$3(Predicate typeSafePredicate, List entities, class_1297 entity) {
        if (typeSafePredicate.test(entity)) {
            entities.add(entity);
        }
    }
}

