/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4103;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4170;
import net.minecraft.class_4173;
import net.minecraft.class_4215;
import net.minecraft.class_4831;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrain;
import net.tslat.smartbrainlib.api.core.behaviour.GroupBehaviour;
import net.tslat.smartbrainlib.api.core.schedule.SmartBrainSchedule;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.object.BrainBehaviourConsumer;
import net.tslat.smartbrainlib.object.BrainBehaviourPredicate;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import org.jetbrains.annotations.Nullable;

public final class BrainUtils {
    public static <T> T memoryOrDefault(class_1309 entity, class_4140<T> memory, Supplier<T> fallback) {
        return BrainUtils.memoryOrDefault(entity.method_18868(), memory, fallback);
    }

    public static <T> T memoryOrDefault(class_4095<?> brain, class_4140<T> memory, Supplier<T> fallback) {
        return brain.method_18904(memory).orElseGet(fallback);
    }

    @Nullable
    public static <T> T getMemory(class_1309 entity, class_4140<T> memory) {
        return BrainUtils.getMemory(entity.method_18868(), memory);
    }

    @Nullable
    public static <T> T getMemory(class_4095<?> brain, class_4140<T> memory) {
        return (T)BrainUtils.memoryOrDefault(brain, memory, () -> null);
    }

    public static <T> void withMemory(class_1309 entity, class_4140<T> memory, Consumer<T> consumer) {
        BrainUtils.withMemory(entity.method_18868(), memory, consumer);
    }

    public static <T> void withMemory(class_4095<?> brain, class_4140<T> memory, Consumer<T> consumer) {
        brain.method_18904(memory).ifPresent(consumer);
    }

    public static boolean hasMemory(class_1309 entity, class_4140<?> memory) {
        return BrainUtils.hasMemory(entity.method_18868(), memory);
    }

    public static boolean hasMemory(class_4095<?> brain, class_4140<?> memory) {
        return brain.method_18896(memory);
    }

    public static long getTimeUntilMemoryExpires(class_1309 entity, class_4140<?> memory) {
        return BrainUtils.getTimeUntilMemoryExpires(entity.method_18868(), memory);
    }

    public static long getTimeUntilMemoryExpires(class_4095<?> brain, class_4140<?> memory) {
        return brain.method_36978(memory);
    }

    public static <T> void setMemory(class_1309 entity, class_4140<T> memoryType, T memory) {
        BrainUtils.setMemory(entity.method_18868(), memoryType, memory);
    }

    public static <T> void setMemory(class_4095<?> brain, class_4140<T> memoryType, T memory) {
        brain.method_18878(memoryType, memory);
    }

    public static <T> void setForgettableMemory(class_1309 entity, class_4140<T> memoryType, T memory, int expirationTicks) {
        BrainUtils.setForgettableMemory(entity.method_18868(), memoryType, memory, expirationTicks);
    }

    public static <T> void setForgettableMemory(class_4095<?> brain, class_4140<T> memoryType, T memory, int expirationTicks) {
        brain.method_24525(memoryType, memory, (long)expirationTicks);
    }

    public static void clearMemory(class_1309 entity, class_4140<?> memory) {
        BrainUtils.clearMemory(entity.method_18868(), memory);
    }

    public static void clearMemory(class_4095<?> brain, class_4140<?> memory) {
        brain.method_18875(memory);
    }

    public static void clearMemories(class_1309 entity, class_4140<?> ... memories) {
        BrainUtils.clearMemories(entity.method_18868(), memories);
    }

    public static void clearMemories(class_4095<?> brain, class_4140<?> ... memories) {
        for (class_4140<?> memory : memories) {
            brain.method_18875(memory);
        }
    }

    @Nullable
    public static class_1309 getTargetOfEntity(class_1309 entity) {
        return BrainUtils.getTargetOfEntity(entity, null);
    }

    @Nullable
    public static class_1309 getTargetOfEntity(class_1309 entity, @Nullable class_1309 fallback) {
        return BrainUtils.memoryOrDefault(entity.method_18868(), class_4140.field_22355, () -> fallback);
    }

    @Nullable
    public static class_1309 getLastAttacker(class_1309 entity) {
        return (class_1309)BrainUtils.memoryOrDefault(entity, class_4140.field_18452, null);
    }

    public static void setTargetOfEntity(class_1309 entity, @Nullable class_1309 target) {
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            mob.method_5980(target);
        }
        if (target == null) {
            BrainUtils.clearMemory(entity, class_4140.field_22355);
        } else {
            BrainUtils.setMemory(entity, class_4140.field_22355, target);
        }
    }

    public static boolean canSee(class_1309 entity, class_1309 target) {
        class_4095 brain = entity.method_18868();
        if (class_4215.method_19550((class_4095)brain, (class_1309)target)) {
            return true;
        }
        return entity.method_6057((class_1297)target);
    }

    public static void setSpecialCooldown(class_1309 entity, int ticks) {
        BrainUtils.setForgettableMemory(entity, SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get(), Boolean.valueOf(true), ticks);
    }

    public static boolean isOnSpecialCooldown(class_1309 entity) {
        return BrainUtils.hasMemory(entity, SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get());
    }

    public static Stream<class_4097<?>> getAllBehaviours(class_4095<?> brain) {
        if (brain instanceof SmartBrain) {
            SmartBrain smartBrain = (SmartBrain)brain;
            return smartBrain.getBehaviours();
        }
        return brain.field_18324.values().stream().map(Map::values).flatMap(set -> set.stream().map(value -> value.stream().toList()).flatMap(Collection::stream));
    }

    public static void forEachBehaviour(class_4095<?> brain, BrainBehaviourConsumer consumer) {
        if (brain instanceof SmartBrain) {
            SmartBrain smartBrain = (SmartBrain)brain;
            smartBrain.forEachBehaviour(consumer);
            return;
        }
        Set behaviours = brain.field_18324.entrySet();
        for (Map.Entry priorityEntry : behaviours) {
            Integer priority = (Integer)priorityEntry.getKey();
            for (Map.Entry activityEntry : ((Map)priorityEntry.getValue()).entrySet()) {
                class_4168 activity = (class_4168)activityEntry.getKey();
                for (class_4097 behaviour : (Set)activityEntry.getValue()) {
                    BrainUtils.consumeBehaviour(priority, activity, behaviour, null, consumer);
                }
            }
        }
    }

    private static <E extends class_1309> void consumeBehaviour(int priority, class_4168 activity, class_4097<E> behaviour, @Nullable class_4097<E> parentBehaviour, BrainBehaviourConsumer consumer) {
        consumer.consume(priority, activity, behaviour, parentBehaviour);
        if (behaviour instanceof class_4103) {
            class_4103 groupBehaviour = (class_4103)behaviour;
            groupBehaviour.field_18347.method_35094().forEach(childBehaviour -> BrainUtils.consumeBehaviour(priority, activity, childBehaviour, groupBehaviour, consumer));
        } else if (behaviour instanceof GroupBehaviour) {
            GroupBehaviour groupBehaviour = (GroupBehaviour)behaviour;
            groupBehaviour.getBehaviours().forEachRemaining(childBehaviour -> BrainUtils.consumeBehaviour(priority, activity, childBehaviour, groupBehaviour, consumer));
        }
    }

    public static <E extends class_1309> void removeBehaviour(E entity, BrainBehaviourPredicate predicate) {
        class_4095 class_40952 = entity.method_18868();
        if (class_40952 instanceof SmartBrain) {
            SmartBrain smartBrain = (SmartBrain)class_40952;
            smartBrain.removeBehaviour(entity, predicate);
            return;
        }
        Set behaviours = entity.method_18868().field_18324.entrySet();
        for (Map.Entry entry : behaviours) {
            Integer priority = (Integer)entry.getKey();
            for (Map.Entry activityEntry : ((Map)entry.getValue()).entrySet()) {
                class_4168 activity = (class_4168)activityEntry.getKey();
                Iterator iterator = ((Set)activityEntry.getValue()).iterator();
                while (iterator.hasNext()) {
                    class_4097 behaviour = (class_4097)iterator.next();
                    BrainUtils.checkBehaviour(priority, activity, behaviour, null, predicate, () -> {
                        if (behaviour.method_18921() == class_4097.class_4098.field_18338) {
                            behaviour.method_18925((class_3218)entity.method_37908(), entity, entity.field_6002.method_8510());
                        }
                        iterator.remove();
                    });
                }
            }
        }
    }

    private static <E extends class_1309> void checkBehaviour(int priority, class_4168 activity, class_4097<E> behaviour, @Nullable class_4097<E> parentBehaviour, BrainBehaviourPredicate predicate, Runnable callback) {
        if (predicate.isBehaviour(priority, activity, behaviour, parentBehaviour)) {
            callback.run();
        } else if (behaviour instanceof class_4103) {
            class_4103 groupBehaviour = (class_4103)behaviour;
            Iterator childBehaviourIterator = groupBehaviour.field_18347.method_35094().iterator();
            while (childBehaviourIterator.hasNext()) {
                BrainUtils.checkBehaviour(priority, activity, (class_4097)childBehaviourIterator.next(), groupBehaviour, predicate, childBehaviourIterator::remove);
            }
            if (!groupBehaviour.field_18347.method_35094().iterator().hasNext()) {
                callback.run();
            }
        } else if (behaviour instanceof GroupBehaviour) {
            GroupBehaviour groupBehaviour = (GroupBehaviour)behaviour;
            Iterator childBehaviourIterator = groupBehaviour.getBehaviours();
            while (childBehaviourIterator.hasNext()) {
                BrainUtils.checkBehaviour(priority, activity, childBehaviourIterator.next(), groupBehaviour, predicate, childBehaviourIterator::remove);
            }
            if (!groupBehaviour.getBehaviours().hasNext()) {
                callback.run();
            }
        }
    }

    public static void addBehaviour(class_4095<?> brain, int priority, class_4168 activity, class_4097 behaviourControl) {
        if (brain instanceof SmartBrain) {
            SmartBrain smartBrain = (SmartBrain)brain;
            smartBrain.addBehaviour(priority, activity, behaviourControl);
            return;
        }
        brain.field_18324.computeIfAbsent(priority, priority2 -> Maps.newHashMap()).computeIfAbsent(activity, activity2 -> Sets.newLinkedHashSet()).add(behaviourControl);
    }

    public static void addActivity(class_4095<?> brain, BrainActivityGroup<?> behaviourGroup) {
        if (brain instanceof SmartBrain) {
            SmartBrain smartBrain = (SmartBrain)brain;
            smartBrain.addActivity(behaviourGroup);
            return;
        }
        brain.method_24530(behaviourGroup.getActivity(), behaviourGroup.pairBehaviourPriorities(), behaviourGroup.getActivityStartMemoryConditions(), behaviourGroup.getWipedMemoriesOnFinish());
    }

    public static <S extends class_4148<?>> void addSensor(class_4095<?> brain, class_4149<S> sensorType, S sensor) {
        if (brain instanceof SmartBrain) {
            SmartBrain smartBrain = (SmartBrain)brain;
            if (!(sensor instanceof ExtendedSensor)) {
                throw new IllegalArgumentException("Attempted to provide sensor to SmartBrain, only ExtendedSensor subclasses acceptable. Sensor: " + sensor.getClass());
            }
            ExtendedSensor extendedSensor = (ExtendedSensor)sensor;
            smartBrain.addSensor(extendedSensor);
            return;
        }
        brain.field_18323.put(sensorType, sensor);
        BrainUtils.addMemories(brain, sensor.method_19099().toArray(new class_4140[0]));
    }

    public static void addMemories(class_4095<?> brain, class_4140<?> ... memories) {
        if (brain instanceof SmartBrain) {
            SmartBrain smartBrain = (SmartBrain)brain;
            for (class_4140<?> memoryType : memories) {
                smartBrain.method_18904(memoryType);
            }
            return;
        }
        for (class_4140<?> memoryType : memories) {
            brain.field_18322.computeIfAbsent(memoryType, key -> Optional.empty()).map(class_4831::method_24637);
        }
    }

    public static void addScheduledActivityTransition(class_4095<?> brain, class_4168 activity, int tickTime, SmartBrainSchedule.Type tickType) {
        if (brain instanceof SmartBrain) {
            SmartBrain smartBrain = (SmartBrain)brain;
            SmartBrainSchedule schedule = smartBrain.getSchedule();
            if (schedule == null) {
                schedule = new SmartBrainSchedule(tickType);
                smartBrain.setSchedule(schedule);
            }
            schedule.activityAt(tickTime, activity);
        } else {
            class_4170 schedule = brain.method_18894();
            if (schedule == class_4170.field_18603) {
                brain.method_18884(new class_4170());
            }
            class_4173 timeline = schedule.field_18607.computeIfAbsent(activity, key -> new class_4173());
            timeline.method_19227(tickTime, 1.0f);
            for (Map.Entry entry : schedule.field_18607.entrySet()) {
                if (entry.getKey() == activity) continue;
                ((class_4173)entry.getValue()).method_19227(tickTime, 0.0f);
            }
        }
    }
}

