/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.move;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class StrafeTarget<E extends class_1314>
extends ExtendedBehaviour<E> {
    private static final List<Pair<class_4140<?>, class_4141>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)class_4140.field_22355, (Object)class_4141.field_18456), Pair.of((Object)class_4140.field_18445, (Object)class_4141.field_18457)});
    protected boolean strafingLaterally = false;
    protected boolean strafingBack = false;
    protected int strafeCounter = -1;
    protected float strafeDistanceSqr = 244.0f;
    protected Predicate<E> stopStrafingWhen = entity -> false;
    protected float speedMod = 1.0f;

    @Override
    protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public StrafeTarget<E> stopStrafingWhen(Predicate<E> predicate) {
        this.stopStrafingWhen = predicate;
        return this;
    }

    public StrafeTarget<E> strafeDistance(float distance) {
        this.strafeDistanceSqr = distance * distance;
        return this;
    }

    public StrafeTarget<E> speedMod(float modifier) {
        this.speedMod = modifier;
        return this;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return BrainUtils.hasMemory(entity, class_4140.field_22355) && !this.stopStrafingWhen.test(entity);
    }

    @Override
    protected void tick(E entity) {
        class_1309 target = BrainUtils.getTargetOfEntity(entity);
        double distanceToTarget = target.method_5858(entity);
        if (distanceToTarget <= (double)this.strafeDistanceSqr) {
            entity.method_5942().method_6340();
            ++this.strafeCounter;
        } else {
            entity.method_5942().method_6335((class_1297)target, (double)this.speedMod);
            this.strafeCounter = -1;
        }
        if (this.strafeCounter >= 20) {
            if ((double)entity.method_6051().method_43057() < 0.3) {
                boolean bl = this.strafingLaterally = !this.strafingLaterally;
            }
            if ((double)entity.method_6051().method_43057() < 0.3) {
                this.strafingBack = !this.strafingBack;
            }
            this.strafeCounter = 0;
        }
        if (this.strafeCounter > -1) {
            if (distanceToTarget > (double)(this.strafeDistanceSqr * 0.75f)) {
                this.strafingBack = false;
            } else if (distanceToTarget < (double)(this.strafeDistanceSqr * 0.25f)) {
                this.strafingBack = true;
            }
            entity.method_5951((class_1297)target, 30.0f, 30.0f);
            entity.method_5962().method_6243(this.strafingBack ? -0.5f : 0.5f, this.strafingLaterally ? 0.5f : -0.5f);
        }
    }
}

