/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.util;

import com.favouriteless.enchanted.Enchanted;
import com.favouriteless.enchanted.platform.CommonServices;
import com.favouriteless.enchanted.util.JsonHelper;
import com.google.gson.JsonObject;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.jetbrains.annotations.NotNull;

public class ItemStackHelper {
    public static void dropContentsNoChange(class_1937 level, double x, double y, double z, class_1263 inventory) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 item = inventory.method_5438(i).method_7972();
            double width = class_1299.field_6052.method_17685();
            double inverseWidth = 1.0 - width;
            double radius = width / 2.0;
            double dx = Math.floor(x) + Enchanted.RANDOM.nextDouble() * inverseWidth + radius;
            double dy = Math.floor(y) + Enchanted.RANDOM.nextDouble() * inverseWidth;
            double dz = Math.floor(z) + Enchanted.RANDOM.nextDouble() * inverseWidth + radius;
            while (!item.method_7960()) {
                class_1542 entity = new class_1542(level, dx, dy, dz, item.method_7971(Enchanted.RANDOM.nextInt(21) + 10));
                entity.method_18800(Enchanted.RANDOM.nextGaussian() * 0.05, Enchanted.RANDOM.nextGaussian() * 0.05 + 0.2, Enchanted.RANDOM.nextGaussian() * 0.05);
                level.method_8649((class_1297)entity);
            }
        }
    }

    public static boolean isFuel(class_1799 stack) {
        return CommonServices.PLATFORM.getBurnTime(stack, null) > 0;
    }

    public static class_1799 fromJson(JsonObject json, boolean readNbt) {
        class_1792 item = (class_1792)class_2378.field_11142.method_10223(new class_2960(class_3518.method_15265((JsonObject)json, (String)"item")));
        int count = class_3518.method_15282((JsonObject)json, (String)"count", (int)1);
        class_1799 out = new class_1799((class_1935)item, count);
        if (readNbt && json.has("nbt")) {
            out.method_7980(JsonHelper.readTag(json.get("nbt")));
        }
        return out;
    }

    public static JsonObject asJson(class_1799 item, boolean saveNbt) {
        return ItemStackHelper.asJson(item.method_7909(), item.method_7947(), saveNbt && item.method_7985() ? item.method_7969() : null);
    }

    public static JsonObject asJson(class_1792 item, int count, class_2487 nbt) {
        JsonObject obj = new JsonObject();
        obj.addProperty("item", class_2378.field_11142.method_10221((Object)item).toString());
        if (count > 1) {
            obj.addProperty("count", (Number)count);
        }
        if (nbt != null) {
            class_2487 noDamage = nbt.method_10553();
            noDamage.method_10551("Damage");
            if (!noDamage.method_33133()) {
                obj.addProperty("nbt", noDamage.method_10714());
            }
        }
        return obj;
    }

    public static boolean isSameIgnoreDurability(@NotNull class_1799 a, @NotNull class_1799 b) {
        if (a == b) {
            return true;
        }
        if (a.method_7960() && b.method_7960()) {
            return true;
        }
        if (!a.method_7960() && !b.method_7960()) {
            if (a.method_7985() != b.method_7985()) {
                return false;
            }
            if (a.method_7985()) {
                class_2487 aTag = a.method_7969();
                class_2487 bTag = a.method_7969();
                for (String key : aTag.method_10541()) {
                    if (key.equals("Damage") || bTag.method_10545(key) && !bTag.method_10580(key).equals(aTag.method_10580(key))) continue;
                    return false;
                }
            }
        }
        return false;
    }
}

