/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.patchouli.components;

import com.favouriteless.enchanted.Enchanted;
import com.favouriteless.enchanted.api.rites.AbstractRite;
import com.favouriteless.enchanted.common.init.registry.EnchantedBlocks;
import com.favouriteless.enchanted.common.init.registry.RiteTypes;
import com.favouriteless.enchanted.common.rites.CirclePart;
import com.favouriteless.enchanted.util.Vector2i;
import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.client.RenderHelper;
import vazkii.patchouli.client.book.gui.BookTextRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;

public class RiteRequirementsComponent
implements ICustomComponent {
    public static final String PATH = "textures/patchouli/";
    public static final String FILE_END = ".png";
    public static final int IMAGE_SIZE = 110;
    public static final int TEXTURE_SIZE = 128;
    public static final float IMAGE_OFFSET = 55.0f;
    public static final HashMap<class_2248, String> BLOCK_IMAGES = new HashMap();
    public int startRadius;
    public float scale;
    public int itemsFirstCircle;
    @SerializedName(value="rite")
    public IVariable riteName;
    private transient BookTextRenderer powerTextRenderer;
    private transient AbstractRite rite;
    private final transient List<ItemRing> itemRings = new ArrayList<ItemRing>();
    private final transient List<class_2960> circleImages = new ArrayList<class_2960>();
    private transient int x;
    private transient int y;

    public void build(int componentX, int componentY, int pageNum) {
        this.x = componentX;
        this.y = componentY;
        this.repopulateCircleResources();
        this.repopulateRings();
    }

    public void render(class_4587 matrix, IComponentRenderContext context, float partialticks, int mouseX, int mouseY) {
        Object object;
        if (this.rite != null && (object = context.getGui()) instanceof GuiBook) {
            GuiBook gui = (GuiBook)object;
            for (class_2960 resourceLocation : this.circleImages) {
                this.renderCircle(matrix, resourceLocation);
            }
            for (ItemRing ring : this.itemRings) {
                ring.render(matrix, gui, mouseX, mouseY);
            }
            this.powerTextRenderer.render(matrix, mouseX, mouseY);
        }
    }

    public void onDisplayed(IComponentRenderContext context) {
        class_437 gui = context.getGui();
        if (gui instanceof GuiBookEntry) {
            GuiBookEntry entry = (GuiBookEntry)gui;
            this.powerTextRenderer = new BookTextRenderer((GuiBook)entry, (class_2561)class_2561.method_43470((String)(this.rite.POWER + " Power Required")), 2, 140, 116, 9, 0);
        }
    }

    private void repopulateCircleResources() {
        this.circleImages.clear();
        if (this.rite != null) {
            this.circleImages.add(Enchanted.location("textures/patchouli/gold.png"));
            class_2960 small = this.getImageResource(CirclePart.SMALL, "small");
            class_2960 medium = this.getImageResource(CirclePart.MEDIUM, "medium");
            class_2960 large = this.getImageResource(CirclePart.LARGE, "large");
            if (small != null) {
                this.circleImages.add(small);
            }
            if (medium != null) {
                this.circleImages.add(medium);
            }
            if (large != null) {
                this.circleImages.add(large);
            }
        }
    }

    private class_2960 getImageResource(CirclePart part, String suffix) {
        for (class_2248 block : BLOCK_IMAGES.keySet()) {
            if (!this.rite.hasCircle(part, block)) continue;
            return Enchanted.location(BLOCK_IMAGES.get(block) + "_" + suffix + FILE_END);
        }
        return null;
    }

    private void renderCircle(class_4587 matrix, class_2960 resourceLocation) {
        RenderSystem.setShaderTexture((int)0, (class_2960)resourceLocation);
        matrix.method_22903();
        matrix.method_22904((double)((float)this.x - 55.0f), (double)((float)this.y - 55.0f), 0.0);
        RenderSystem.enableBlend();
        class_332.method_25290((class_4587)matrix, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)110, (int)110, (int)128, (int)128);
        matrix.method_22909();
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        AbstractRite rite = RiteTypes.getDefaultByName(new class_2960(((IVariable)lookup.apply(this.riteName)).asString()));
        if (rite == null) {
            throw new IllegalStateException();
        }
        this.rite = rite;
    }

    public void repopulateRings() {
        if (this.rite != null) {
            this.itemRings.clear();
            List<class_1799> items = this.getItems();
            int index = 0;
            int currentItems = this.itemsFirstCircle;
            int currentRadius = this.startRadius;
            while (true) {
                List<class_1799> subList = items.subList(index, Math.min(items.size(), index + currentItems));
                this.itemRings.add(new ItemRing(subList, this.x, this.y, currentRadius, this.scale));
                if ((index += currentItems) >= items.size()) break;
                currentItems *= 2;
                currentRadius += 17;
            }
        }
    }

    private List<class_1799> getItems() {
        class_1799[] items = new class_1799[this.rite.ITEMS_REQUIRED.keySet().size()];
        int i = 0;
        for (class_1792 item : this.rite.ITEMS_REQUIRED.keySet()) {
            items[i] = new class_1799((class_1935)item, this.rite.ITEMS_REQUIRED.get(item).intValue());
            ++i;
        }
        return Arrays.asList(items);
    }

    static {
        BLOCK_IMAGES.put(EnchantedBlocks.CHALK_WHITE.get(), "textures/patchouli/white");
        BLOCK_IMAGES.put(EnchantedBlocks.CHALK_RED.get(), "textures/patchouli/red");
        BLOCK_IMAGES.put(EnchantedBlocks.CHALK_PURPLE.get(), "textures/patchouli/purple");
    }

    private static class ItemRing {
        private final List<class_1799> items;
        private final float scale;
        private final Vector2i[] scaledPositions;
        private final Vector2i[] absPositions;
        private final int itemSize;

        private ItemRing(List<class_1799> items, int x, int y, float radius, float scale) {
            this.items = items;
            this.itemSize = Math.round(16.0f * scale);
            this.scaledPositions = new Vector2i[items.size()];
            this.absPositions = new Vector2i[items.size()];
            this.scale = scale;
            this.recalculatePositions(x, y, radius);
        }

        private void recalculatePositions(int x, int y, float radius) {
            double xLocal = 0.0;
            double yLocal = -radius / this.scale;
            double angle = Math.toRadians(360.0 / (double)this.items.size());
            double sin = Math.sin(angle);
            double cos = Math.cos(angle);
            for (int i = 0; i < this.scaledPositions.length; ++i) {
                this.scaledPositions[i] = new Vector2i((int)Math.round(xLocal + (double)((float)x / this.scale) - 8.0), (int)Math.round(yLocal + (double)((float)y / this.scale) - 8.0));
                this.absPositions[i] = new Vector2i((int)Math.round(xLocal * (double)this.scale + (double)x - (double)(8.0f * this.scale)), (int)Math.round(yLocal * (double)this.scale + (double)y - (double)(8.0f * this.scale)));
                class_243 newLocalPos = new class_243(cos * xLocal - sin * yLocal, sin * xLocal + cos * yLocal, 0.0);
                xLocal = newLocalPos.field_1352;
                yLocal = newLocalPos.field_1351;
            }
        }

        private void render(class_4587 matrix, GuiBook gui, int mouseX, int mouseY) {
            matrix.method_22903();
            matrix.method_22905(this.scale, this.scale, this.scale);
            for (int i = 0; i < this.items.size(); ++i) {
                class_1799 item = this.items.get(i);
                Vector2i scaledPos = this.scaledPositions[i];
                Vector2i absPos = this.absPositions[i];
                class_310 mc = class_310.method_1551();
                RenderHelper.transferMsToGl((class_4587)matrix, () -> {
                    mc.method_1480().method_4023(item, scaledPos.x, scaledPos.y);
                    mc.method_1480().method_4025(mc.field_1772, item, scaledPos.x, scaledPos.y);
                });
                if (!gui.isMouseInRelativeRange((double)mouseX, (double)mouseY, absPos.x, absPos.y, this.itemSize, this.itemSize)) continue;
                gui.setTooltipStack(item);
            }
            matrix.method_22909();
        }
    }
}

