/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.patchouli.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.class_1799;
import net.minecraft.class_4587;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IVariable;

public class ItemListComponent
implements ICustomComponent {
    public boolean startBottom;
    public boolean centered;
    public int itemsPerRow;
    public IVariable itemList;
    public transient List<class_1799> items;
    private transient int x;
    private transient int y;
    private final transient List<ItemRow> itemRows = new ArrayList<ItemRow>();

    public void build(int componentX, int componentY, int pageNum) {
        this.x = componentX;
        this.y = componentY;
        this.repopulateRows();
    }

    public void render(class_4587 matrix, IComponentRenderContext context, float partialTicks, int mouseX, int mouseY) {
        for (ItemRow row : this.itemRows) {
            row.render(matrix, context, mouseX, mouseY);
        }
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        this.items = Arrays.asList((class_1799[])((IVariable)lookup.apply(this.itemList)).as(class_1799[].class));
    }

    public void repopulateRows() {
        this.itemRows.clear();
        int startY = this.startBottom ? this.y - (int)Math.ceil((float)this.items.size() / (float)this.itemsPerRow) * 16 : this.y;
        for (int index = 0; index < this.items.size(); index += this.itemsPerRow) {
            List<class_1799> subList = this.items.subList(index, Math.min(this.items.size(), index + this.itemsPerRow));
            this.itemRows.add(new ItemRow(subList, this.x, startY + index / this.itemsPerRow * 16, this.centered));
        }
    }

    private static class ItemRow {
        private final List<class_1799> items;
        private final int x;
        private final int y;

        private ItemRow(List<class_1799> items, int x, int y, boolean centered) {
            this.items = items;
            this.x = centered ? Math.round((float)x - (float)(items.size() * 16) / 2.0f) : x;
            this.y = y;
        }

        private void render(class_4587 matrix, IComponentRenderContext context, int mouseX, int mouseY) {
            int xOffset = 0;
            for (class_1799 stack : this.items) {
                context.renderItemStack(matrix, this.x + xOffset, this.y, mouseX, mouseY, stack);
                xOffset += 16;
            }
        }
    }
}

