/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.common.rites.world;

import com.favouriteless.enchanted.api.rites.AbstractRite;
import com.favouriteless.enchanted.common.CommonConfig;
import com.favouriteless.enchanted.common.init.registry.EnchantedBlocks;
import com.favouriteless.enchanted.common.init.registry.EnchantedItems;
import com.favouriteless.enchanted.common.init.registry.EnchantedParticleTypes;
import com.favouriteless.enchanted.common.rites.CirclePart;
import com.favouriteless.enchanted.common.rites.RiteType;
import com.favouriteless.enchanted.util.WaystoneHelper;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class RiteSkyWrath
extends AbstractRite {
    private static long LAST_USE_TIME = System.currentTimeMillis();
    public static final int START_RAINING = 120;
    public static final int EXPLODE = 180;
    public static final double LIGHTNING_RADIUS = 5.0;
    private class_2338 targetPos = null;
    private class_1937 targetLevel = null;

    public RiteSkyWrath(RiteType<?> type, class_3218 level, class_2338 pos, UUID caster, int power, int powerTick) {
        super(type, level, pos, caster, power, powerTick);
    }

    public RiteSkyWrath(RiteType<?> type, class_3218 level, class_2338 pos, UUID caster) {
        this(type, level, pos, caster, 1000, 0);
        this.CIRCLES_REQUIRED.put(CirclePart.SMALL, EnchantedBlocks.CHALK_WHITE.get());
        this.ITEMS_REQUIRED.put(class_1802.field_8371, 1);
        this.ITEMS_REQUIRED.put(EnchantedItems.QUICKLIME.get(), 1);
    }

    @Override
    public void execute() {
        class_1937 class_19372;
        class_3218 level = this.getLevel();
        class_2338 pos = this.getPos();
        this.detatchFromChalk();
        LAST_USE_TIME = System.currentTimeMillis();
        List<class_1297> entities = CirclePart.SMALL.getEntitiesInside((class_1937)level, pos, entity -> entity instanceof class_1542);
        for (class_1297 entity2 : entities) {
            if (!(entity2 instanceof class_1542)) continue;
            class_1542 itemEntity = (class_1542)entity2;
            if (itemEntity.method_6983().method_7909() == EnchantedItems.BOUND_WAYSTONE.get()) {
                if (!itemEntity.method_6983().method_7985()) continue;
                this.targetPos = WaystoneHelper.getPos(itemEntity.method_6983());
                this.targetLevel = WaystoneHelper.getLevel((class_1937)level, itemEntity.method_6983());
                if (this.targetPos == null) continue;
                itemEntity.method_6989();
                itemEntity.method_31472();
                this.playConsumeEffects(itemEntity);
                break;
            }
            if (itemEntity.method_6983().method_7909() != EnchantedItems.BLOODED_WAYSTONE.get() || !itemEntity.method_6983().method_7985()) continue;
            this.setTargetEntity(WaystoneHelper.getEntity((class_1937)level, itemEntity.method_6983()));
            class_1297 targetEntity = this.getTargetEntity();
            if (targetEntity == null) continue;
            this.targetPos = targetEntity.method_24515();
            this.targetLevel = targetEntity.field_6002;
            itemEntity.method_6989();
            itemEntity.method_31472();
            this.playConsumeEffects(itemEntity);
            break;
        }
        if (this.targetPos != null && this.targetLevel != null && (class_19372 = this.targetLevel) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14199((class_2394)EnchantedParticleTypes.SKY_WRATH_SEED.get(), (double)this.targetPos.method_10263() + 0.5, (double)this.targetPos.method_10264() + 2.0, (double)this.targetPos.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        } else {
            level.method_14199((class_2394)EnchantedParticleTypes.SKY_WRATH_SEED.get(), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 2.0, (double)pos.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void onTick() {
        class_3218 level = this.getLevel();
        class_2338 pos = this.getPos();
        if (this.ticks == 120L) {
            level.method_27910(0, 6000, true, true);
        } else if (this.ticks > 180L) {
            if (this.targetPos != null) {
                this.spawnLightning(this.targetLevel, (double)this.targetPos.method_10263() + 0.5, this.targetPos.method_10264(), (double)this.targetPos.method_10260() + 0.5);
            } else {
                this.spawnLightning((class_1937)level, (double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
            }
            this.stopExecuting();
        }
    }

    @Override
    protected boolean checkAdditional() {
        if (System.currentTimeMillis() - LAST_USE_TIME < (long)((Integer)CommonConfig.SKY_WRATH_COOLDOWN.get()).intValue() * 1000L) {
            class_3222 caster = this.getLevel().method_8503().method_3760().method_14602(this.getCasterUUID());
            caster.method_7353((class_2561)class_2561.method_43470((String)"The sky is not ready to release lightning.").method_27692(class_124.field_1061), false);
            return false;
        }
        return true;
    }

    protected void spawnLightning(class_1937 pLevel, double x, double y, double z) {
        for (int a = 0; a < 360; a += 60) {
            double angle = Math.toRadians(a);
            double cx = x + Math.sin(angle) * 5.0;
            double cz = z + Math.cos(angle) * 5.0;
            class_1538 lightningBolt = (class_1538)class_1299.field_6112.method_5883(pLevel);
            lightningBolt.method_24203(cx, y, cz);
            pLevel.method_8649((class_1297)lightningBolt);
        }
    }
}

