/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.common.rites.world;

import com.favouriteless.enchanted.Enchanted;
import com.favouriteless.enchanted.api.rites.AbstractRite;
import com.favouriteless.enchanted.common.CommonConfig;
import com.favouriteless.enchanted.common.init.EnchantedTags;
import com.favouriteless.enchanted.common.init.registry.EnchantedBlocks;
import com.favouriteless.enchanted.common.init.registry.EnchantedItems;
import com.favouriteless.enchanted.common.init.registry.EnchantedParticleTypes;
import com.favouriteless.enchanted.common.rites.CirclePart;
import com.favouriteless.enchanted.common.rites.RiteType;
import com.favouriteless.enchanted.mixin.SaplingBlockAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2473;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4538;

public class RiteForest
extends AbstractRite {
    private final int treeCount = (Integer)CommonConfig.FOREST_TREE_COUNT.get();
    private int treesPlaced = 0;
    private int tries = 0;
    private final List<class_2338> usedPositions = new ArrayList<class_2338>();
    private class_2473 saplingBlock = null;

    public RiteForest(RiteType<?> type, class_3218 level, class_2338 pos, UUID caster) {
        super(type, level, pos, caster, 4000, 0);
        this.CIRCLES_REQUIRED.put(CirclePart.MEDIUM, EnchantedBlocks.CHALK_WHITE.get());
        this.ITEMS_REQUIRED.put(EnchantedItems.WICKER_BUNDLE.get(), 1);
        this.ITEMS_REQUIRED.put(EnchantedItems.BREW_OF_SPROUTING.get(), 1);
        this.ITEMS_REQUIRED.put(EnchantedItems.ENT_TWIG.get(), 1);
    }

    @Override
    public void execute() {
        class_3218 level = this.getLevel();
        class_2338 pos = this.getPos();
        List<class_1297> entities = CirclePart.MEDIUM.getEntitiesInside((class_1937)level, pos);
        for (class_1297 entity : entities) {
            class_2473 block;
            class_1747 blockItem;
            class_2248 class_22482;
            class_1542 itemEntity;
            class_1799 stack;
            class_1792 class_17922;
            if (!(entity instanceof class_1542) || !((class_17922 = (stack = (itemEntity = (class_1542)entity).method_6983()).method_7909()) instanceof class_1747) || !((class_22482 = (blockItem = (class_1747)class_17922).method_7711()) instanceof class_2473)) continue;
            this.saplingBlock = block = (class_2473)class_22482;
            this.consumeItemNoRequirement(itemEntity);
            break;
        }
        if (this.saplingBlock != null) {
            level.method_8396(null, pos, class_3417.field_14905, class_3419.field_15250, 0.5f, 1.0f);
        } else {
            this.cancel();
        }
    }

    @Override
    public void onTick() {
        if (this.ticks % 20L == 0L) {
            class_3218 level = this.getLevel();
            class_2338 pos = this.getPos();
            if (level != null) {
                class_243 randomPos = new class_243(Enchanted.RANDOM.nextGaussian(), 0.0, Enchanted.RANDOM.nextGaussian()).method_1029().method_1021(Math.cbrt(Math.random()) * (double)((Integer)CommonConfig.FOREST_RADIUS.get()).intValue());
                int minHeight = Math.max(level.method_31607(), pos.method_10264() - (Integer)CommonConfig.FOREST_RADIUS.get() / 2);
                int maxHeight = Math.min(level.method_31600(), pos.method_10264() + (Integer)CommonConfig.FOREST_RADIUS.get() / 2);
                for (int y = minHeight; y < maxHeight; ++y) {
                    class_2680 state;
                    class_2338 treePos = new class_2338((int)Math.round(randomPos.method_10216()) + pos.method_10263(), y, (int)Math.round(randomPos.method_10215()) + pos.method_10260());
                    if (!this.notNearUsed(treePos) || !(state = level.method_8320(treePos)).method_26215() && !state.method_26164(EnchantedTags.Blocks.RITE_FOREST_REPLACEABLE) || !this.saplingBlock.method_9558(this.saplingBlock.method_9564(), (class_4538)level, treePos)) continue;
                    if (!((SaplingBlockAccessor)this.saplingBlock).getTreeGrower().method_11431(level, level.method_14178().method_12129(), treePos, state, Enchanted.RANDOMSOURCE)) break;
                    ++this.treesPlaced;
                    level.method_8396(null, pos, class_3417.field_21905, class_3419.field_15250, 3.0f, 1.0f);
                    this.usedPositions.add(treePos);
                    break;
                }
                level.method_14199((class_2394)EnchantedParticleTypes.FERTILITY_SEED.get(), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                ++this.tries;
                if (this.treesPlaced == this.treeCount) {
                    this.stopExecuting();
                } else if ((double)this.tries >= (double)this.treeCount * 2.5) {
                    this.stopExecuting();
                }
            } else {
                this.stopExecuting();
            }
        }
    }

    @Override
    protected void saveAdditional(class_2487 nbt) {
        class_2499 usedPosTag = new class_2499();
        for (class_2338 pos : this.usedPositions) {
            usedPosTag.add((Object)class_2512.method_10692((class_2338)pos));
        }
        nbt.method_10566("usedPositions", (class_2520)usedPosTag);
    }

    @Override
    protected boolean loadAdditional(class_2487 nbt, class_1937 level) {
        if (!nbt.method_10545("usedPositions")) {
            return false;
        }
        this.usedPositions.clear();
        class_2499 usedPosTag = nbt.method_10554("usedPositions", 10);
        for (class_2520 tag : usedPosTag) {
            this.usedPositions.add(class_2512.method_10691((class_2487)((class_2487)tag)));
        }
        return true;
    }

    private boolean notNearUsed(class_2338 pos) {
        for (class_2338 usedPos : this.usedPositions) {
            if (!(usedPos.method_10268((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) < 16.0)) continue;
            return false;
        }
        return true;
    }
}

