/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.common.rites.world;

import com.favouriteless.enchanted.Enchanted;
import com.favouriteless.enchanted.api.rites.AbstractRite;
import com.favouriteless.enchanted.common.CommonConfig;
import com.favouriteless.enchanted.common.init.EnchantedTags;
import com.favouriteless.enchanted.common.init.registry.EnchantedBlocks;
import com.favouriteless.enchanted.common.init.registry.EnchantedItems;
import com.favouriteless.enchanted.common.init.registry.EnchantedParticleTypes;
import com.favouriteless.enchanted.common.rites.CirclePart;
import com.favouriteless.enchanted.common.rites.RiteType;
import com.favouriteless.enchanted.mixin.ZombieVillagerAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1641;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;

public class RiteFertility
extends AbstractRite {
    public static final int RADIUS = 25;
    public static final int RADIUS_SQ = 625;
    public static final int TICKS_PER_BLOCK = 5;
    public Set<class_1309> entities;
    public Set<class_2338> positions;
    public int blockTicks = 0;

    public RiteFertility(RiteType<?> type, class_3218 level, class_2338 pos, UUID caster, int power) {
        super(type, level, pos, caster, power, 0);
    }

    public RiteFertility(RiteType<?> type, class_3218 level, class_2338 pos, UUID caster) {
        this(type, level, pos, caster, 3000);
        this.CIRCLES_REQUIRED.put(CirclePart.SMALL, EnchantedBlocks.CHALK_WHITE.get());
        this.ITEMS_REQUIRED.put(class_1802.field_8324, 1);
        this.ITEMS_REQUIRED.put(EnchantedItems.HINT_OF_REBIRTH.get(), 1);
        this.ITEMS_REQUIRED.put(EnchantedItems.DIAMOND_VAPOUR.get(), 1);
        this.ITEMS_REQUIRED.put(EnchantedItems.QUICKLIME.get(), 1);
        this.ITEMS_REQUIRED.put(EnchantedItems.GYPSUM.get(), 1);
        this.ITEMS_REQUIRED.put(EnchantedItems.MUTANDIS.get(), 1);
    }

    @Override
    protected void execute() {
        this.entities = this.getLivingEntities();
        this.positions = this.getBlockPosSet();
    }

    @Override
    protected void onTick() {
        class_3218 level = this.getLevel();
        class_2338 pos = this.getPos();
        if (level != null) {
            if (this.ticks % 5L == 0L) {
                ArrayList<class_1309> entitiesHandled = new ArrayList<class_1309>();
                for (class_1309 entity : this.entities) {
                    if (!(entity.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) < (double)(this.blockTicks * this.blockTicks))) continue;
                    if (entity instanceof class_1641) {
                        class_1641 villager = (class_1641)entity;
                        ((ZombieVillagerAccessor)villager).startConverting(this.getCasterUUID(), Enchanted.RANDOM.nextInt(2401) + 3600);
                    }
                    Collection effects = entity.method_6026();
                    ArrayList<class_1291> toRemove = new ArrayList<class_1291>();
                    for (class_1293 class_12932 : effects) {
                        if (!((class_6880)class_2378.field_11159.method_40265(class_1291.method_5554((class_1291)class_12932.method_5579())).get()).method_40220(EnchantedTags.MobEffects.FERTILITY_CURE_EFFECTS)) continue;
                        toRemove.add(class_12932.method_5579());
                    }
                    for (class_1291 class_12912 : toRemove) {
                        entity.method_6016(class_12912);
                    }
                    entitiesHandled.add(entity);
                }
                ArrayList<class_2338> positionsHandled = new ArrayList<class_2338>();
                for (class_2338 _pos : this.positions) {
                    if (!(pos.method_10268((double)_pos.method_10263() + 0.5, (double)_pos.method_10264() + 0.5, (double)_pos.method_10260() + 0.5) < (double)(this.blockTicks * this.blockTicks))) continue;
                    class_2680 state = level.method_8320(_pos);
                    class_2248 class_22482 = state.method_26204();
                    if (class_22482 instanceof class_2256) {
                        class_2256 block = (class_2256)class_22482;
                        if (Math.random() < (Double)CommonConfig.FERTILITY_BONE_MEAL_CHANCE.get()) {
                            block.method_9652(level, level.field_9229, _pos, state);
                        }
                    }
                    positionsHandled.add(_pos);
                }
                entitiesHandled.forEach(this.entities::remove);
                positionsHandled.forEach(this.positions::remove);
                ++this.blockTicks;
                if (this.positions.isEmpty()) {
                    this.stopExecuting();
                }
            }
            if (this.ticks % 25L == 0L) {
                level.method_8396(null, pos, class_3417.field_14671, class_3419.field_15250, 0.1f, 1.0f);
                level.method_14199((class_2394)EnchantedParticleTypes.FERTILITY_SEED.get(), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 2.0, (double)pos.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            }
        } else {
            this.stopExecuting();
        }
    }

    public Set<class_1309> getLivingEntities() {
        HashSet<class_1309> entities = new HashSet<class_1309>();
        class_3218 level = this.getLevel();
        class_2338 pos = this.getPos();
        if (level != null) {
            for (class_1297 entity : level.method_27909()) {
                if (!(entity instanceof class_1309)) continue;
                class_1309 livingEntity = (class_1309)entity;
                if (!(entity.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) <= 625.0)) continue;
                entities.add(livingEntity);
            }
        }
        return entities;
    }

    public Set<class_2338> getBlockPosSet() {
        class_2338 pos = this.getPos();
        HashSet<class_2338> positions = new HashSet<class_2338>();
        for (int x = -25; x < 25; ++x) {
            for (int y = -25; y < 25; ++y) {
                for (int z = -25; z < 25; ++z) {
                    if (!(pos.method_10268((double)(pos.method_10263() + x), (double)(pos.method_10264() + y), (double)(pos.method_10260() + z)) < 625.0)) continue;
                    positions.add(new class_2338(pos.method_10263() + x, pos.method_10264() + y, pos.method_10260() + z));
                }
            }
        }
        return positions;
    }
}

