/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.common.rites.processing;

import com.favouriteless.enchanted.api.rites.AbstractRite;
import com.favouriteless.enchanted.common.CommonConfig;
import com.favouriteless.enchanted.common.init.EnchantedTags;
import com.favouriteless.enchanted.common.init.registry.EnchantedBlocks;
import com.favouriteless.enchanted.common.init.registry.EnchantedItems;
import com.favouriteless.enchanted.common.init.registry.EnchantedParticleTypes;
import com.favouriteless.enchanted.common.rites.CirclePart;
import com.favouriteless.enchanted.common.rites.RiteType;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3861;
import net.minecraft.class_3956;

public class RiteBroiling
extends AbstractRite {
    public static final double CIRCLE_RADIUS = 3.0;

    public RiteBroiling(RiteType<?> type, class_3218 level, class_2338 pos, UUID caster, int power) {
        super(type, level, pos, caster, power, 0);
    }

    public RiteBroiling(RiteType<?> type, class_3218 level, class_2338 pos, UUID caster) {
        this(type, level, pos, caster, 1000);
        this.CIRCLES_REQUIRED.put(CirclePart.SMALL, EnchantedBlocks.CHALK_RED.get());
        this.ITEMS_REQUIRED.put(class_1802.field_8713, 1);
        this.ITEMS_REQUIRED.put(class_1802.field_8894, 1);
        this.ITEMS_REQUIRED.put(EnchantedItems.WOOD_ASH.get(), 1);
    }

    @Override
    public void execute() {
        this.detatchFromChalk();
    }

    @Override
    public void onTick() {
        if (this.ticks % 5L == 0L) {
            class_3218 level = this.getLevel();
            class_2338 pos = this.getPos();
            if (level != null) {
                List<class_1297> entitiesInside = CirclePart.SMALL.getEntitiesInside((class_1937)level, pos, entity -> entity instanceof class_1542);
                entitiesInside.removeIf(e -> !((class_1542)e).method_6983().method_31573(EnchantedTags.Items.RAW_FOODS));
                entitiesInside.sort((a, b) -> a.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10263() + 0.5) > b.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10263() + 0.5) ? 1 : 0);
                if (entitiesInside.isEmpty()) {
                    this.stopExecuting();
                    return;
                }
                class_1542 itemEntity = (class_1542)entitiesInside.get(0);
                class_3861 recipe = this.getRecipeFor(itemEntity);
                if (recipe == null) {
                    entitiesInside.remove(0);
                    return;
                }
                int totalCount = itemEntity.method_6983().method_7947();
                int burnedCount = 0;
                for (int i = 0; i < totalCount; ++i) {
                    if (!(Math.random() < (Double)CommonConfig.BROILING_BURN_CHANCE.get())) continue;
                    ++burnedCount;
                }
                level.method_43129(null, (class_1297)itemEntity, class_3417.field_14970, class_3419.field_15250, 1.0f, 1.0f);
                this.replaceItem(itemEntity, new class_1799((class_1935)recipe.method_8110().method_7909(), recipe.method_8110().method_7947() * (totalCount - burnedCount)), new class_1799((class_1935)class_1802.field_8665, burnedCount));
                level.method_14199((class_2394)class_2398.field_27783, itemEntity.method_19538().method_10216(), itemEntity.method_19538().method_10214(), itemEntity.method_19538().field_1350, 25, 0.2, 0.2, 0.2, 0.0);
                level.method_14199((class_2394)EnchantedParticleTypes.BROILING_SEED.get(), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private class_3861 getRecipeFor(class_1542 item) {
        return this.getLevel().method_8433().method_30027(class_3956.field_17546).stream().filter(recipe -> ((class_1856)recipe.method_8117().get(0)).method_8093(item.method_6983())).findFirst().orElse(null);
    }
}

