/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.common.rites.entity.protection;

import com.favouriteless.enchanted.api.rites.AbstractRite;
import com.favouriteless.enchanted.client.particles.types.DoubleParticleType;
import com.favouriteless.enchanted.common.init.registry.EnchantedBlocks;
import com.favouriteless.enchanted.common.init.registry.EnchantedItems;
import com.favouriteless.enchanted.common.init.registry.EnchantedParticleTypes;
import com.favouriteless.enchanted.common.rites.CirclePart;
import com.favouriteless.enchanted.common.rites.RiteType;
import com.favouriteless.enchanted.common.rites.entity.protection.RiteOfProtectionObserver;
import com.favouriteless.enchanted.util.WaystoneHelper;
import com.favouriteless.stateobserver.StateObserverManager;
import com.favouriteless.stateobserver.api.StateObserver;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;

public class RiteProtection
extends AbstractRite {
    private RiteOfProtectionObserver stateObserver = null;
    protected final int radius;
    protected final class_2248 block;
    protected class_3218 targetLevel = null;
    protected class_2338 targetPos = null;

    public RiteProtection(RiteType<?> type, class_3218 level, class_2338 pos, UUID caster, int power, int powerTick, int radius, class_2248 block) {
        super(type, level, pos, caster, power, powerTick);
        this.radius = radius;
        this.block = block;
    }

    public RiteProtection(RiteType<?> type, class_3218 level, class_2338 pos, UUID caster) {
        this(type, level, pos, caster, 500, 4, 4, EnchantedBlocks.PROTECTION_BARRIER.get());
        this.CIRCLES_REQUIRED.put(CirclePart.SMALL, EnchantedBlocks.CHALK_WHITE.get());
        this.ITEMS_REQUIRED.put(class_1802.field_8281, 1);
        this.ITEMS_REQUIRED.put(class_1802.field_8725, 1);
    }

    @Override
    public void execute() {
        this.findTargetPos();
        this.generateSphere(this.block);
        this.getOrCreateObserver();
        this.targetLevel.method_14199((class_2394)new DoubleParticleType.DoubleParticleData(EnchantedParticleTypes.PROTECTION_SEED.get(), this.radius), (double)this.targetPos.method_10263() + 0.5, (double)this.targetPos.method_10264() + 0.6, (double)this.targetPos.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
    }

    @Override
    protected void onTick() {
        if (this.targetLevel.method_8477(this.targetPos) && this.ticks % 20L == 0L) {
            this.stateObserver.checkChanges();
            this.targetLevel.method_14199((class_2394)new DoubleParticleType.DoubleParticleData(EnchantedParticleTypes.PROTECTION_SEED.get(), this.radius), (double)this.targetPos.method_10263() + 0.5, (double)this.targetPos.method_10264() + 0.6, (double)this.targetPos.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void onStopExecuting() {
        this.generateSphere(class_2246.field_10124);
        StateObserverManager.removeObserver((StateObserver)this.stateObserver);
    }

    protected void generateSphere(class_2248 block) {
        class_2338.class_2339 spherePos = new class_2338.class_2339(0, 0, 0);
        double increment = 1.0 / (double)this.radius;
        for (double y = 0.0; y <= Math.PI * 2 + increment / 2.0; y += increment) {
            for (double p = 0.0; p <= Math.PI * 2 + increment / 2.0; p += increment) {
                double cosY = Math.cos(y);
                double sinY = Math.sin(y);
                double cosP = Math.cos(p);
                double sinP = Math.sin(p);
                spherePos.method_10103((int)Math.round(sinY * cosP * (double)this.radius) + this.targetPos.method_10263(), (int)Math.round(sinP * (double)this.radius) + this.targetPos.method_10264(), (int)Math.round(cosY * cosP * (double)this.radius) + this.targetPos.method_10260());
                if (!this.targetLevel.method_8320((class_2338)spherePos).method_26215() && !this.targetLevel.method_8320((class_2338)spherePos).method_27852(EnchantedBlocks.PROTECTION_BARRIER.get()) && !this.targetLevel.method_8320((class_2338)spherePos).method_27852(EnchantedBlocks.PROTECTION_BARRIER_TEMPORARY.get())) continue;
                this.targetLevel.method_8501((class_2338)spherePos, block.method_9564());
            }
        }
    }

    protected void findTargetPos() {
        class_3218 level = this.getLevel();
        class_2338 pos = this.getPos();
        List<class_1297> items = CirclePart.SMALL.getEntitiesInside((class_1937)level, pos);
        for (class_1297 entity : items) {
            if (!(entity instanceof class_1542)) continue;
            class_1542 itemEntity = (class_1542)entity;
            class_1799 stack = itemEntity.method_6983();
            if (stack.method_7909() == EnchantedItems.BOUND_WAYSTONE.get()) {
                this.targetLevel = (class_3218)WaystoneHelper.getLevel((class_1937)level, stack);
                this.targetPos = WaystoneHelper.getPos(stack);
                this.consumeItemNoRequirement(itemEntity);
                break;
            }
            if (stack.method_7909() != EnchantedItems.BLOODED_WAYSTONE.get()) continue;
            this.setTargetEntity(WaystoneHelper.getEntity((class_1937)level, stack));
            this.targetLevel = (class_3218)this.getTargetEntity().method_37908();
            this.targetPos = this.getTargetEntity().method_24515();
            this.consumeItemNoRequirement(itemEntity);
            break;
        }
        if (this.targetLevel == null) {
            this.targetLevel = level;
        }
        if (this.targetPos == null) {
            this.targetPos = pos;
        }
    }

    @Override
    protected boolean loadAdditional(class_2487 nbt, class_1937 level) {
        if (!nbt.method_10545("targetLevel")) {
            return false;
        }
        if (!nbt.method_10545("targetX")) {
            return false;
        }
        if (!nbt.method_10545("targetY")) {
            return false;
        }
        if (!nbt.method_10545("targetZ")) {
            return false;
        }
        this.targetLevel = level.method_8503().method_3847(class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(nbt.method_10558("targetLevel"))));
        this.targetPos = new class_2338(nbt.method_10550("targetX"), nbt.method_10550("targetY"), nbt.method_10550("targetZ"));
        this.getOrCreateObserver();
        this.generateSphere(this.block);
        return true;
    }

    @Override
    protected void saveAdditional(class_2487 nbt) {
        nbt.method_10582("targetLevel", this.targetLevel.method_27983().method_29177().toString());
        nbt.method_10569("targetX", this.targetPos.method_10263());
        nbt.method_10569("targetY", this.targetPos.method_10264());
        nbt.method_10569("targetZ", this.targetPos.method_10260());
    }

    protected void getOrCreateObserver() {
        if (this.stateObserver == null) {
            this.stateObserver = (RiteOfProtectionObserver)StateObserverManager.getObserver((class_1937)this.getLevel(), (class_2338)this.targetPos, RiteOfProtectionObserver.class);
        }
        if (this.stateObserver == null) {
            this.stateObserver = (RiteOfProtectionObserver)StateObserverManager.createObserver((StateObserver)new RiteOfProtectionObserver((class_1937)this.targetLevel, this.targetPos, this.radius + 1, this.radius + 1, this.radius + 1, this.block));
        }
    }
}

