/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.common.rites.binding;

import com.favouriteless.enchanted.api.rites.AbstractRite;
import com.favouriteless.enchanted.common.init.registry.EnchantedBlocks;
import com.favouriteless.enchanted.common.init.registry.EnchantedItems;
import com.favouriteless.enchanted.common.rites.CirclePart;
import com.favouriteless.enchanted.common.rites.RiteType;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class RiteBindingTalisman
extends AbstractRite {
    protected RiteBindingTalisman(RiteType<?> type, class_3218 level, class_2338 pos, UUID caster, int power) {
        super(type, level, pos, caster, power, 0);
    }

    public RiteBindingTalisman(RiteType<?> type, class_3218 level, class_2338 pos, UUID caster) {
        this(type, level, pos, caster, 1000);
        this.ITEMS_REQUIRED.put(EnchantedItems.CIRCLE_TALISMAN.get(), 1);
        this.ITEMS_REQUIRED.put(class_1802.field_8725, 1);
    }

    @Override
    public void execute() {
        byte small = this.testForCircle(CirclePart.SMALL);
        byte medium = this.testForCircle(CirclePart.MEDIUM);
        byte large = this.testForCircle(CirclePart.LARGE);
        if (small == 0 && medium == 0 && large == 0) {
            this.cancel();
            this.stopExecuting();
            return;
        }
        class_2487 nbt = new class_2487();
        nbt.method_10567("small", small);
        nbt.method_10567("medium", medium);
        nbt.method_10567("large", large);
        class_1799 talisman = new class_1799((class_1935)EnchantedItems.CIRCLE_TALISMAN.get(), 1);
        talisman.method_7980(nbt);
        class_3218 level = this.getLevel();
        class_2338 pos = this.getPos();
        level.method_8649((class_1297)new class_1542((class_1937)level, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, talisman));
        level.method_8396(null, pos, class_3417.field_14905, class_3419.field_15250, 1.0f, 1.0f);
        this.spawnMagicParticles();
        if (small != 0) {
            CirclePart.SMALL.destroy((class_1937)level, pos);
        }
        if (medium != 0) {
            CirclePart.MEDIUM.destroy((class_1937)level, pos);
        }
        if (large != 0) {
            CirclePart.LARGE.destroy((class_1937)level, pos);
        }
        level.method_8501(pos, class_2246.field_10124.method_9564());
        this.stopExecuting();
    }

    @Override
    protected boolean checkAdditional() {
        for (class_1799 item : this.itemsConsumed) {
            if (item.method_7909() != EnchantedItems.CIRCLE_TALISMAN.get() || !item.method_7985()) continue;
            this.cancel();
            class_3222 player = this.tryFindCaster();
            if (player != null) {
                player.method_7353((class_2561)class_2561.method_43470((String)"Talisman already contains a circle").method_27692(class_124.field_1061), false);
            }
            return false;
        }
        return true;
    }

    private byte testForCircle(CirclePart circle) {
        class_2338 pos;
        class_3218 level = this.getLevel();
        if (circle.match((class_1937)level, pos = this.getPos(), EnchantedBlocks.CHALK_WHITE.get())) {
            return 1;
        }
        if (circle.match((class_1937)level, pos, EnchantedBlocks.CHALK_RED.get())) {
            return 2;
        }
        if (circle.match((class_1937)level, pos, EnchantedBlocks.CHALK_PURPLE.get())) {
            return 3;
        }
        return 0;
    }
}

