/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.common.rites.binding;

import com.favouriteless.enchanted.Enchanted;
import com.favouriteless.enchanted.api.familiars.FamiliarSavedData;
import com.favouriteless.enchanted.api.familiars.FamiliarType;
import com.favouriteless.enchanted.api.rites.AbstractRite;
import com.favouriteless.enchanted.common.init.registry.EnchantedBlocks;
import com.favouriteless.enchanted.common.init.registry.EnchantedItems;
import com.favouriteless.enchanted.common.init.registry.EnchantedParticleTypes;
import com.favouriteless.enchanted.common.init.registry.EnchantedSoundEvents;
import com.favouriteless.enchanted.common.init.registry.FamiliarTypes;
import com.favouriteless.enchanted.common.rites.CirclePart;
import com.favouriteless.enchanted.common.rites.RiteType;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class RiteBindingFamiliar
extends AbstractRite {
    public static final int BIND_TICKS = 300;
    public static final int START_SOUND = 175;
    public static final class_243 OFFSET = new class_243(0.5, 2.5, 0.5);

    public RiteBindingFamiliar(RiteType<?> type, class_3218 level, class_2338 pos, UUID caster) {
        super(type, level, pos, caster, 8000, 0);
        this.CIRCLES_REQUIRED.put(CirclePart.MEDIUM, EnchantedBlocks.CHALK_WHITE.get());
        this.ITEMS_REQUIRED.put(EnchantedItems.TEAR_OF_THE_GODDESS.get(), 1);
        this.ITEMS_REQUIRED.put(EnchantedItems.ODOUR_OF_PURITY.get(), 1);
        this.ITEMS_REQUIRED.put(EnchantedItems.WHIFF_OF_MAGIC.get(), 1);
        this.ITEMS_REQUIRED.put(class_1802.field_8477, 1);
        this.ITEMS_REQUIRED.put(EnchantedItems.DEMONIC_BLOOD.get(), 1);
    }

    @Override
    protected void execute() {
        class_3218 level = this.getLevel();
        class_2338 pos = this.getPos();
        class_1297 targetEntity = this.getTargetEntity();
        if (targetEntity != null) {
            class_243 newPos = new class_243(RiteBindingFamiliar.OFFSET.field_1352 + (double)pos.method_10263(), RiteBindingFamiliar.OFFSET.field_1351 + (double)pos.method_10264(), RiteBindingFamiliar.OFFSET.field_1350 + (double)pos.method_10260());
            targetEntity.method_5875(true);
            level.method_8396(null, targetEntity.method_24515(), class_3417.field_14879, class_3419.field_15254, 1.0f, 1.0f);
            double offset = (double)targetEntity.method_17681() / 1.5;
            level.method_14199((class_2394)class_2398.field_11214, targetEntity.method_23317(), targetEntity.method_23318(), targetEntity.method_23321(), 20 + Enchanted.RANDOM.nextInt(10), offset, offset, offset, 0.0);
            targetEntity.method_5859(newPos.field_1352, newPos.field_1351, newPos.field_1350);
            level.method_14199((class_2394)class_2398.field_11214, targetEntity.method_23317(), targetEntity.method_23318(), targetEntity.method_23321(), 20 + Enchanted.RANDOM.nextInt(10), offset, offset, offset, 0.0);
            level.method_14199((class_2394)EnchantedParticleTypes.BIND_FAMILIAR_SEED.get(), newPos.field_1352, newPos.field_1351, newPos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void onTick() {
        if (!this.stillValid()) {
            this.stopExecuting();
            return;
        }
        class_3218 level = this.getLevel();
        class_2338 pos = this.getPos();
        class_1297 targetEntity = this.getTargetEntity();
        UUID casterUUID = this.getCasterUUID();
        if (this.ticks == 175L) {
            level.method_43128(null, (double)pos.method_10263() + RiteBindingFamiliar.OFFSET.field_1352, (double)pos.method_10264() + RiteBindingFamiliar.OFFSET.field_1351, (double)pos.method_10260() + RiteBindingFamiliar.OFFSET.field_1350, EnchantedSoundEvents.BIND_FAMILIAR.get(), class_3419.field_15250, 1.5f, 1.0f);
        }
        if (this.ticks < 300L) {
            double dx = (double)pos.method_10263() + RiteBindingFamiliar.OFFSET.field_1352 + Enchanted.RANDOM.nextDouble() * 0.2 - 0.1;
            double dy = (double)pos.method_10264() + RiteBindingFamiliar.OFFSET.field_1351 + Enchanted.RANDOM.nextDouble() * 0.2 - 0.1 - (double)targetEntity.method_17682() / 2.0;
            double dz = (double)pos.method_10260() + RiteBindingFamiliar.OFFSET.field_1350 + Enchanted.RANDOM.nextDouble() * 0.2 - 0.1;
            targetEntity.method_5859(dx, dy, dz);
        } else {
            FamiliarType<?, ?> type = FamiliarTypes.getByInput(targetEntity.method_5864());
            if (type != null) {
                Object familiar = type.getFor(level);
                familiar.method_5814(targetEntity.method_23317(), targetEntity.method_23318(), targetEntity.method_23321());
                familiar.method_6174(casterUUID);
                familiar.method_6173(true);
                familiar.method_5665(targetEntity.method_5797());
                familiar.method_5971();
                FamiliarSavedData data = FamiliarSavedData.get((class_1937)level);
                data.setFamiliar(casterUUID, type, (class_1321)familiar);
                data.method_80();
                Enchanted.LOG.info(String.format("Familiar of type %s bound to %s", type.getId().toString(), casterUUID));
                level.method_8649(familiar);
                targetEntity.method_31472();
            }
            this.stopExecuting();
        }
    }

    private boolean stillValid() {
        return this.getTargetEntity() != null && this.getTargetEntity().method_5805();
    }

    @Override
    protected boolean checkAdditional() {
        class_3218 level = this.getLevel();
        class_2338 pos = this.getPos();
        UUID casterUUID = this.getCasterUUID();
        List<class_1297> entities = CirclePart.MEDIUM.getEntitiesInside((class_1937)level, pos, entity -> FamiliarTypes.getByInput(entity.method_5864()) != null);
        if (!entities.isEmpty()) {
            class_1321 animal;
            UUID ownerUUID;
            class_1297 class_12972 = entities.get(0);
            if (class_12972 instanceof class_1321 && (ownerUUID = (animal = (class_1321)class_12972).method_6139()) != null && !ownerUUID.equals(this.getCasterUUID())) {
                class_1657 caster = level.method_18470(casterUUID);
                if (caster != null) {
                    caster.method_7353((class_2561)class_2561.method_43470((String)"This creature does not trust you.").method_27692(class_124.field_1061), false);
                }
                return false;
            }
            this.setTargetEntity(entities.get(0));
            return true;
        }
        return false;
    }
}

