/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.common.rites;

import com.favouriteless.enchanted.common.init.registry.EnchantedBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_4538;

public enum CirclePart {
    SMALL("  XXX   XOOOX XOOOOOXXOOOOOXXOOOOOX XOOOX   XXX  "),
    MEDIUM("   XXXXX     XOOOOOX   XOOOOOOOX XOOOOOOOOOXXOOOOOOOOOXXOOOOOOOOOXXOOOOOOOOOXXOOOOOOOOOX XOOOOOOOX   XOOOOOX     XXXXX   "),
    LARGE("    XXXXXXX       XOOOOOOOX     XOOOOOOOOOX   XOOOOOOOOOOOX XOOOOOOOOOOOOOXXOOOOOOOOOOOOOXXOOOOOOOOOOOOOXXOOOOOOOOOOOOOXXOOOOOOOOOOOOOXXOOOOOOOOOOOOOXXOOOOOOOOOOOOOX XOOOOOOOOOOOX   XOOOOOOOOOX     XOOOOOOOX       XXXXXXX    ");

    private final List<class_2338> circlePoints = new ArrayList<class_2338>();
    private final List<class_2338> insideCirclePoints = new ArrayList<class_2338>();
    private final List<class_238> insideBoxes = new ArrayList<class_238>();

    private CirclePart(String shape) {
        int x;
        int z;
        int size = (int)Math.sqrt(shape.length());
        int offset = size / 2;
        for (z = 0; z < size; ++z) {
            for (x = 0; x < size; ++x) {
                char c = shape.charAt(x + size * z);
                class_2338 pos = new class_2338(x - offset, 0, z - offset);
                if (c == 'X') {
                    this.circlePoints.add(pos);
                    this.insideCirclePoints.add(pos);
                    continue;
                }
                if (c != 'O') continue;
                this.insideCirclePoints.add(pos);
            }
        }
        for (z = 0; z < size; ++z) {
            for (x = 0; x < size; ++x) {
                int index = x + size * z;
                if (shape.charAt(index) != 'X' && shape.charAt(index) != 'O') continue;
                AABBBuilder builder = new AABBBuilder(shape, x, z, size);
                shape = builder.build();
                this.insideBoxes.add(builder.get());
            }
        }
    }

    public boolean match(class_1937 level, class_2338 centerPos, class_2248 block) {
        for (class_2338 pos : this.circlePoints) {
            if (level.method_8320(centerPos.method_10081((class_2382)pos)).method_27852(block)) continue;
            return false;
        }
        return true;
    }

    public void destroy(class_1937 level, class_2338 centerPos) {
        for (class_2338 pos : this.circlePoints) {
            level.method_8501(centerPos.method_10081((class_2382)pos), class_2246.field_10124.method_9564());
        }
    }

    public boolean canPlace(class_1937 level, class_2338 centerPos) {
        for (class_2338 pos : this.circlePoints) {
            if (level.method_8320(centerPos.method_10081((class_2382)pos)).method_26215() && EnchantedBlocks.CHALK_WHITE.get().method_9558(null, (class_4538)level, centerPos.method_10081((class_2382)pos))) continue;
            return false;
        }
        return true;
    }

    public void place(class_1937 level, class_2338 centerPos, class_2248 block, class_1838 context) {
        for (class_2338 pos : this.circlePoints) {
            level.method_8501(centerPos.method_10081((class_2382)pos), block.method_9605(new class_1750(context)));
        }
    }

    public List<class_1297> getEntitiesInside(class_1937 level, class_2338 centerPos) {
        ArrayList<class_1297> outlist = new ArrayList<class_1297>();
        for (class_238 aabb : this.insideBoxes) {
            outlist.addAll(level.method_8333((class_1297)null, aabb.method_996(centerPos), entity -> !outlist.contains(entity)));
        }
        return outlist;
    }

    public List<class_1297> getEntitiesInside(class_1937 level, class_2338 centerPos, Predicate<class_1297> predicate) {
        List<class_1297> outlist = this.getEntitiesInside(level, centerPos);
        outlist.removeIf(entity -> !predicate.test((class_1297)entity));
        return outlist;
    }

    public class_1297 getClosestEntity(class_1937 level, class_2338 centerPos) {
        return this.closest(this.getEntitiesInside(level, centerPos), centerPos);
    }

    public class_1297 closest(List<class_1297> entities, class_2338 pos) {
        class_243 center = new class_243((double)pos.method_10263() + 0.5, 0.0, (double)pos.method_10260() + 0.5);
        double closest = Double.MAX_VALUE;
        class_1297 entity = null;
        for (class_1297 newEntity : entities) {
            double newDistance = newEntity.method_5707(center);
            if (!(newDistance < closest)) continue;
            closest = newDistance;
            entity = newEntity;
        }
        return entity;
    }

    public class_1297 getClosestEntity(class_1937 level, class_2338 centerPos, Predicate<class_1297> predicate) {
        List<class_1297> entities = this.getEntitiesInside(level, centerPos);
        entities.removeIf(entity -> !predicate.test((class_1297)entity));
        return this.closest(entities, centerPos);
    }

    public List<class_2338> getCirclePoints() {
        return this.circlePoints;
    }

    public List<class_2338> getInsideCirclePoints() {
        return this.insideCirclePoints;
    }

    private static class AABBBuilder {
        private String shape;
        private final int xStart;
        private final int zStart;
        private final int size;
        private class_238 aabb = null;

        private AABBBuilder(String shape, int xStart, int zStart, int size) {
            this.shape = shape;
            this.xStart = xStart;
            this.zStart = zStart;
            this.size = size;
        }

        private String build() {
            int index;
            int x = this.xStart;
            int z = this.zStart;
            int startIndex = x + this.size * z;
            int offset = this.size / 2;
            while (true) {
                index = x + this.size * z;
                char nextChar = this.shape.charAt(index + 1);
                if (x + 1 >= this.size || nextChar != 'X' && nextChar != 'O') break;
                ++x;
            }
            String row = this.shape.substring(startIndex, index + 1);
            while (true) {
                int rowStartIndex = startIndex + this.size * (z - this.zStart + 1);
                int rowEndIndex = rowStartIndex + row.length();
                if (z + 1 >= this.size) {
                    this.aabb = new class_238((double)(this.xStart - offset), 0.0, (double)(this.zStart - offset), (double)(x + 1 - offset), 5.0, (double)(z + 1 - offset));
                    this.removeShapeSub(this.xStart, this.zStart, x, z);
                    break;
                }
                String newRow = this.shape.substring(rowStartIndex, rowEndIndex);
                if (!this.rowEquals(row, newRow)) {
                    this.aabb = new class_238((double)(this.xStart - offset), 0.0, (double)(this.zStart - offset), (double)(x + 1 - offset), 5.0, (double)(z + 1 - offset));
                    this.removeShapeSub(this.xStart, this.zStart, x, z);
                    break;
                }
                ++z;
            }
            return this.shape;
        }

        private boolean rowEquals(String row, String newRow) {
            row = row.replace('O', 'X');
            newRow = newRow.replace('O', 'X');
            return row.equals(newRow);
        }

        private void removeShapeSub(int x, int y, int x2, int y2) {
            char[] shapeChars = this.shape.toCharArray();
            for (int a = x; a <= x2; ++a) {
                for (int b = y; b <= y2; ++b) {
                    shapeChars[a + this.size * b] = 32;
                }
            }
            this.shape = String.valueOf(shapeChars);
        }

        private class_238 get() {
            return this.aabb;
        }
    }
}

