/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.common.reloadlisteners.altar;

import com.favouriteless.enchanted.Enchanted;
import com.favouriteless.enchanted.common.altar.AltarPowerProvider;
import com.favouriteless.enchanted.common.init.registry.PowerProviderRegistry;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class PowerProviderReloadListener<T>
extends class_4309 {
    private final KeySupplier<T> keySupplier;
    private final PowerProviderRegistry<T> registry;

    public PowerProviderReloadListener(String directory, KeySupplier<T> keySupplier, PowerProviderRegistry<T> registry) {
        super(new Gson(), directory);
        this.keySupplier = keySupplier;
        this.registry = registry;
    }

    protected void apply(Map<class_2960, JsonElement> jsonMap, class_3300 manager, class_3695 profiler) {
        this.registry.reset();
        jsonMap.forEach((resourceLocation, jsonElement) -> {
            try {
                JsonObject jsonObject = class_3518.method_15295((JsonElement)jsonElement, (String)"powerprovider");
                T key = this.keySupplier.get((class_2960)resourceLocation);
                int power = class_3518.method_15260((JsonObject)jsonObject, (String)"power");
                int limit = class_3518.method_15260((JsonObject)jsonObject, (String)"limit");
                if (key != null && power != 0 && limit > 0) {
                    AltarPowerProvider<T> provider = new AltarPowerProvider<T>(key, power, limit);
                    this.registry.register(provider);
                }
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                Enchanted.LOG.error("Parsing error loading altar power provider {}: {}", resourceLocation, (Object)jsonparseexception.getMessage());
            }
        });
    }

    @FunctionalInterface
    public static interface KeySupplier<T> {
        public T get(class_2960 var1);
    }
}

