/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.common.recipes;

import com.favouriteless.enchanted.common.init.registry.EnchantedRecipeTypes;
import com.favouriteless.enchanted.common.recipes.CauldronTypeRecipe;
import com.favouriteless.enchanted.util.ItemStackHelper;
import com.favouriteless.enchanted.util.JsonHelper;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class WitchCauldronRecipe
extends CauldronTypeRecipe {
    public WitchCauldronRecipe(class_2960 id, class_2371<class_1799> itemsIn, class_1799 itemOut, int power, int[] cookingColour, int[] finalColour) {
        super(EnchantedRecipeTypes.WITCH_CAULDRON.get(), id, itemsIn, itemOut, power, cookingColour, finalColour);
    }

    public class_1865<?> method_8119() {
        return EnchantedRecipeTypes.WITCH_CAULDRON_SERIALIZER.get();
    }

    public static class Serializer
    implements class_1865<WitchCauldronRecipe> {
        public WitchCauldronRecipe fromJson(class_2960 recipeId, JsonObject json) {
            class_2371<class_1799> itemsIn = JsonHelper.readItemStackList(class_3518.method_15261((JsonObject)json, (String)"ingredients"), true);
            class_1799 itemOut = ItemStackHelper.fromJson(class_3518.method_15296((JsonObject)json, (String)"result"), true);
            int power = class_3518.method_15260((JsonObject)json, (String)"power");
            int[] cookingColour = JsonHelper.readRgb(class_3518.method_15261((JsonObject)json, (String)"cookingColor"));
            int[] finalColour = JsonHelper.readRgb(class_3518.method_15261((JsonObject)json, (String)"finalColor"));
            return new WitchCauldronRecipe(recipeId, itemsIn, itemOut, power, cookingColour, finalColour);
        }

        @Nullable
        public WitchCauldronRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            int inSize = buffer.readInt();
            class_2371 itemsIn = class_2371.method_10211();
            for (int x = 0; x < inSize; ++x) {
                itemsIn.add((Object)buffer.method_10819());
            }
            class_1799 itemOut = buffer.method_10819();
            int power = buffer.readInt();
            int[] cookingColour = new int[]{buffer.readShort(), buffer.readShort(), buffer.readShort()};
            int[] finalColour = new int[]{buffer.readShort(), buffer.readShort(), buffer.readShort()};
            return new WitchCauldronRecipe(recipeId, (class_2371<class_1799>)itemsIn, itemOut, power, cookingColour, finalColour);
        }

        public void toNetwork(class_2540 buffer, WitchCauldronRecipe recipe) {
            buffer.writeInt(recipe.getItemsIn().size());
            for (class_1799 item : recipe.getItemsIn()) {
                buffer.method_10793(item);
            }
            buffer.method_10793(recipe.method_8110());
            buffer.writeInt(recipe.getPower());
            buffer.writeShort(recipe.getCookRed());
            buffer.writeShort(recipe.getCookGreen());
            buffer.writeShort(recipe.getCookBlue());
            buffer.writeShort(recipe.getFinalRed());
            buffer.writeShort(recipe.getFinalGreen());
            buffer.writeShort(recipe.getFinalBlue());
        }
    }
}

