/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.common.recipes;

import com.favouriteless.enchanted.common.init.registry.EnchantedRecipeTypes;
import com.favouriteless.enchanted.util.JsonHelper;
import com.google.gson.JsonObject;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import org.jetbrains.annotations.NotNull;

public class DistillingRecipe
implements class_1860<class_1263> {
    protected final class_3956<?> type = EnchantedRecipeTypes.DISTILLING.get();
    protected final class_2960 id;
    private final class_2371<class_1799> itemsIn;
    private final class_2371<class_1799> itemsOut;
    private final int cookTime;

    public DistillingRecipe(class_2960 id, class_2371<class_1799> itemsIn, class_2371<class_1799> itemsOut, int cookTime) {
        this.id = id;
        this.itemsIn = itemsIn;
        this.itemsOut = itemsOut;
        this.cookTime = cookTime;
    }

    public class_2371<class_1799> getItemsOut() {
        class_2371 out = class_2371.method_10213((int)this.itemsOut.size(), (Object)class_1799.field_8037);
        for (int i = 0; i < this.itemsOut.size(); ++i) {
            out.set(i, (Object)((class_1799)this.itemsOut.get(i)).method_7972());
        }
        return out;
    }

    public class_2371<class_1799> getItemsIn() {
        class_2371 in = class_2371.method_10213((int)this.itemsIn.size(), (Object)class_1799.field_8037);
        for (int i = 0; i < this.itemsIn.size(); ++i) {
            in.set(i, (Object)((class_1799)this.itemsIn.get(i)).method_7972());
        }
        return in;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public boolean method_8115(@NotNull class_1263 inv, @NotNull class_1937 level) {
        int requiredItems = this.getItemsIn().size();
        block0: for (class_1799 stack : this.getItemsIn()) {
            for (int i = 0; i < 3; ++i) {
                class_1799 item = inv.method_5438(i);
                if (!class_1799.method_31577((class_1799)stack, (class_1799)item) || item.method_7947() < stack.method_7947()) continue;
                --requiredItems;
                continue block0;
            }
        }
        return requiredItems == 0;
    }

    @Deprecated
    public class_1799 method_8116(class_1263 inv) {
        return null;
    }

    public boolean method_8113(int width, int height) {
        return false;
    }

    @Deprecated
    public class_1799 method_8110() {
        return class_1799.field_8037;
    }

    @NotNull
    public class_2960 method_8114() {
        return this.id;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return EnchantedRecipeTypes.DISTILLING_SERIALIZER.get();
    }

    @NotNull
    public class_3956<?> method_17716() {
        return this.type;
    }

    public boolean method_8118() {
        return true;
    }

    public static class Serializer
    implements class_1865<DistillingRecipe> {
        @NotNull
        public DistillingRecipe fromJson(@NotNull class_2960 recipeId, @NotNull JsonObject json) {
            class_2371<class_1799> itemsIn = JsonHelper.readItemStackList(class_3518.method_15261((JsonObject)json, (String)"ingredients"), true);
            class_2371<class_1799> itemsOut = JsonHelper.readItemStackList(class_3518.method_15261((JsonObject)json, (String)"results"), true);
            int cookTime = class_3518.method_15282((JsonObject)json, (String)"cookTime", (int)200);
            return new DistillingRecipe(recipeId, itemsIn, itemsOut, cookTime);
        }

        @NotNull
        public DistillingRecipe fromNetwork(@NotNull class_2960 recipeId, class_2540 buffer) {
            int inSize = buffer.readInt();
            class_2371 itemsIn = class_2371.method_10211();
            for (int x = 0; x < inSize; ++x) {
                itemsIn.add((Object)buffer.method_10819());
            }
            int outSize = buffer.readInt();
            class_2371 itemsOut = class_2371.method_10211();
            for (int x = 0; x < outSize; ++x) {
                itemsOut.add((Object)buffer.method_10819());
            }
            int cookTime = buffer.readInt();
            return new DistillingRecipe(recipeId, (class_2371<class_1799>)itemsIn, (class_2371<class_1799>)itemsOut, cookTime);
        }

        public void toNetwork(class_2540 buffer, DistillingRecipe recipe) {
            buffer.writeInt(recipe.getItemsIn().size());
            for (class_1799 stack : recipe.getItemsIn()) {
                buffer.method_10793(stack);
            }
            buffer.writeInt(recipe.getItemsOut().size());
            for (class_1799 stack : recipe.getItemsOut()) {
                buffer.method_10793(stack);
            }
            buffer.writeInt(recipe.getCookTime());
        }
    }
}

