/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.common.poppet;

import com.favouriteless.enchanted.Enchanted;
import com.favouriteless.enchanted.common.items.poppets.AbstractDeathPoppetItem;
import com.favouriteless.enchanted.common.items.poppets.AbstractPoppetItem;
import com.favouriteless.enchanted.common.items.poppets.ItemProtectionPoppetItem;
import com.favouriteless.enchanted.common.network.packets.EnchantedPoppetAnimationPacket;
import com.favouriteless.enchanted.common.poppet.PoppetShelfInventory;
import com.favouriteless.enchanted.common.poppet.PoppetShelfSavedData;
import com.favouriteless.enchanted.platform.CommonServices;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class PoppetHelper {
    public static boolean isBound(class_1799 item) {
        if (item.method_7985()) {
            return item.method_7969().method_25928("boundPlayer");
        }
        return false;
    }

    public static boolean belongsTo(class_1799 item, class_1657 player) {
        class_2487 tag;
        if (item.method_7909() instanceof AbstractPoppetItem && item.method_7985() && (tag = item.method_7969()).method_25928("boundPlayer")) {
            return tag.method_25926("boundPlayer").equals(player.method_5667());
        }
        return false;
    }

    public static boolean belongsTo(class_1799 item, UUID uuid) {
        class_2487 tag;
        if (item.method_7909() instanceof AbstractPoppetItem && item.method_7985() && (tag = item.method_7969()).method_25928("boundPlayer")) {
            return tag.method_25926("boundPlayer").equals(uuid);
        }
        return false;
    }

    public static class_1657 getBoundPlayer(class_1799 item, class_1937 level) {
        if (PoppetHelper.isBound(item)) {
            return level.method_8503().method_3760().method_14602(item.method_7969().method_25926("boundPlayer"));
        }
        return null;
    }

    public static String getBoundName(class_1799 item) {
        if (PoppetHelper.isBound(item)) {
            return item.method_7969().method_10558("boundName");
        }
        return "None";
    }

    public static void bind(class_1799 item, class_1657 player) {
        if (item.method_7909() instanceof AbstractPoppetItem) {
            class_2487 tag = item.method_7948();
            tag.method_25927("boundPlayer", player.method_5667());
            tag.method_10582("boundName", player.method_5476().getString());
            item.method_7980(tag);
        }
    }

    public static void unbind(class_1799 item) {
        if (item.method_7909() instanceof AbstractPoppetItem && item.method_7985()) {
            class_2487 tag = item.method_7969();
            tag.method_10551("boundPlayer");
            tag.method_10551("boundName");
            item.method_7980(tag);
        }
    }

    public static PoppetResult tryUseDeathPoppet(class_1657 player, class_1799 poppetStack, class_3218 level, String shelfIdentifier) {
        class_1792 class_17922 = poppetStack.method_7909();
        if (class_17922 instanceof AbstractDeathPoppetItem) {
            AbstractDeathPoppetItem poppet = (AbstractDeathPoppetItem)class_17922;
            if (PoppetHelper.belongsTo(poppetStack, player) && poppet.canProtect(player)) {
                if (Enchanted.RANDOM.nextFloat() > poppet.getFailRate()) {
                    poppet.protect(player);
                    level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14931, class_3419.field_15248, 0.5f, 1.0f);
                    return PoppetHelper.tryDamagePoppet(poppetStack, level, shelfIdentifier) ? PoppetResult.SUCCESS_BREAK : PoppetResult.SUCCESS;
                }
                return PoppetResult.FAIL;
            }
        }
        return PoppetResult.PASS;
    }

    public static boolean tryUseDeathPoppetQueue(Queue<class_1799> queue, class_1657 player) {
        while (!queue.isEmpty()) {
            class_1799 poppetItem = queue.remove();
            if (!PoppetHelper.handleTryUseDeathPoppet(player, poppetItem, null)) continue;
            return true;
        }
        return false;
    }

    public static boolean tryUseDeathPoppetEntryQueue(Queue<PoppetShelfSavedData.PoppetEntry> queue, class_1657 player) {
        while (!queue.isEmpty()) {
            PoppetShelfSavedData.PoppetEntry entry = queue.remove();
            if (!PoppetHelper.handleTryUseDeathPoppet(player, entry.item(), entry.shelfIdentifier())) continue;
            return true;
        }
        return false;
    }

    public static boolean handleTryUseDeathPoppet(class_1657 player, class_1799 item, String shelfIdentifier) {
        class_1799 poppetItemOriginal = item.method_7972();
        PoppetResult result = PoppetHelper.tryUseDeathPoppet(player, item, (class_3218)player.field_6002, shelfIdentifier);
        return PoppetHelper.handlePoppetResult(result, poppetItemOriginal, player);
    }

    public static PoppetResult tryUseItemProtectionPoppet(class_1657 player, class_1799 poppetStack, class_1799 toolStack, class_3218 level, String shelfIdentifier) {
        class_1792 class_17922 = poppetStack.method_7909();
        if (class_17922 instanceof ItemProtectionPoppetItem) {
            ItemProtectionPoppetItem poppet = (ItemProtectionPoppetItem)class_17922;
            if (PoppetHelper.belongsTo(poppetStack, player)) {
                if (Enchanted.RANDOM.nextFloat() > poppet.getFailRate()) {
                    poppet.protect(toolStack);
                    return PoppetHelper.tryDamagePoppet(poppetStack, level, shelfIdentifier) ? PoppetResult.SUCCESS_BREAK : PoppetResult.SUCCESS;
                }
                return PoppetResult.FAIL;
            }
        }
        return PoppetResult.PASS;
    }

    public static boolean tryUseItemProtectionPoppetQueue(Queue<class_1799> queue, class_1657 player, class_1799 toolStack) {
        while (!queue.isEmpty()) {
            class_1799 poppetItem = queue.remove();
            if (!PoppetHelper.handleTryUseItemProtectionPoppet(player, poppetItem, toolStack, null)) continue;
            return true;
        }
        return false;
    }

    public static boolean tryUseItemProtectionPoppetEntryQueue(Queue<PoppetShelfSavedData.PoppetEntry> queue, class_1657 player, class_1799 toolStack) {
        while (!queue.isEmpty()) {
            PoppetShelfSavedData.PoppetEntry entry = queue.remove();
            if (!PoppetHelper.handleTryUseItemProtectionPoppet(player, entry.item(), toolStack, entry.shelfIdentifier())) continue;
            return true;
        }
        return false;
    }

    public static boolean handleTryUseItemProtectionPoppet(class_1657 player, class_1799 poppetStack, class_1799 toolStack, String shelfIdentifier) {
        class_1799 poppetItemOriginal = poppetStack.method_7972();
        PoppetResult result = PoppetHelper.tryUseItemProtectionPoppet(player, poppetStack, toolStack, (class_3218)player.field_6002, shelfIdentifier);
        return PoppetHelper.handlePoppetResult(result, poppetItemOriginal, player);
    }

    public static boolean tryDamagePoppet(class_1799 item, class_3218 level, String shelfIdentifier) {
        item.method_7974(item.method_7919() + 1);
        if (item.method_7919() >= item.method_7936()) {
            item.method_7934(1);
            if (shelfIdentifier != null && item.method_7947() <= 0) {
                PoppetShelfSavedData data = PoppetShelfSavedData.get((class_1937)level);
                PoppetShelfInventory inventory = data.SHELF_STORAGE.get(shelfIdentifier);
                for (int i = 0; i < inventory.method_5439(); ++i) {
                    if (!inventory.get(i).equals(item)) continue;
                    inventory.set(i, class_1799.field_8037);
                }
                data.updateShelf(shelfIdentifier);
            }
            return true;
        }
        return false;
    }

    private static boolean handlePoppetResult(PoppetResult result, class_1799 poppetItemOriginal, class_1657 player) {
        if (result == PoppetResult.SUCCESS || result == PoppetResult.SUCCESS_BREAK) {
            if (!player.field_6002.field_9236) {
                CommonServices.NETWORK.sendToAllPlayers(new EnchantedPoppetAnimationPacket(result, poppetItemOriginal, player.method_5628()), player.field_6002.method_8503());
            }
            return true;
        }
        return false;
    }

    public static enum PoppetResult {
        SUCCESS,
        SUCCESS_BREAK,
        FAIL,
        PASS;

    }
}

