/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.common.poppet;

import com.favouriteless.enchanted.common.init.EnchantedTags;
import com.favouriteless.enchanted.common.init.registry.EnchantedItems;
import com.favouriteless.enchanted.common.items.poppets.AbstractDeathPoppetItem;
import com.favouriteless.enchanted.common.items.poppets.AbstractPoppetItem;
import com.favouriteless.enchanted.common.items.poppets.ItemProtectionPoppetItem;
import com.favouriteless.enchanted.common.poppet.PoppetHelper;
import com.favouriteless.enchanted.common.poppet.PoppetShelfManager;
import com.favouriteless.enchanted.common.poppet.PoppetShelfSavedData;
import java.util.Comparator;
import java.util.PriorityQueue;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public class PoppetEvents {
    public static boolean onLivingEntityHurt(class_1309 entity, float amount, class_1282 source) {
        class_1657 player;
        if (entity instanceof class_1657 && amount >= (player = (class_1657)entity).method_6032()) {
            PriorityQueue<class_1799> poppetQueue = new PriorityQueue<class_1799>(new PoppetComparator());
            for (class_1799 itemStack : player.method_31548().field_7547) {
                if (!(itemStack.method_7909() instanceof AbstractDeathPoppetItem) || !((AbstractDeathPoppetItem)itemStack.method_7909()).protectsAgainst(source)) continue;
                poppetQueue.add(itemStack);
            }
            boolean cancel = PoppetHelper.tryUseDeathPoppetQueue(poppetQueue, player);
            if (!cancel) {
                PriorityQueue<PoppetShelfSavedData.PoppetEntry> poppetEntryQueue = new PriorityQueue<PoppetShelfSavedData.PoppetEntry>(new PoppetEntryComparator());
                for (PoppetShelfSavedData.PoppetEntry entry : PoppetShelfManager.getEntriesFor(player)) {
                    if (!(entry.item().method_7909() instanceof AbstractDeathPoppetItem) || !((AbstractDeathPoppetItem)entry.item().method_7909()).protectsAgainst(source)) continue;
                    poppetEntryQueue.add(entry);
                }
                cancel = PoppetHelper.tryUseDeathPoppetEntryQueue(poppetEntryQueue, player);
            }
            return cancel;
        }
        return false;
    }

    public static void onPlayerItemBreak(class_1657 player, class_1799 item, class_1268 hand) {
        if (item.method_31573(EnchantedTags.Items.TOOL_POPPET_WHITELIST) && !item.method_31573(EnchantedTags.Items.TOOL_POPPET_BLACKLIST)) {
            PriorityQueue<class_1799> poppetQueue = new PriorityQueue<class_1799>(new PoppetComparator());
            for (class_1799 itemStack : player.method_31548().field_7547) {
                if (!EnchantedItems.isToolPoppet(itemStack.method_7909())) continue;
                poppetQueue.add(itemStack);
            }
            boolean canceled = PoppetHelper.tryUseItemProtectionPoppetQueue(poppetQueue, player, item);
            if (!canceled) {
                PriorityQueue<PoppetShelfSavedData.PoppetEntry> poppetEntryQueue = new PriorityQueue<PoppetShelfSavedData.PoppetEntry>(new PoppetEntryComparator());
                for (PoppetShelfSavedData.PoppetEntry entry : PoppetShelfManager.getEntriesFor(player)) {
                    if (!EnchantedItems.isToolPoppet(entry.item().method_7909())) continue;
                    poppetEntryQueue.add(entry);
                }
                canceled = PoppetHelper.tryUseItemProtectionPoppetEntryQueue(poppetEntryQueue, player, item);
            }
            if (canceled) {
                player.method_6122(hand, item);
            }
        }
    }

    public static void onLivingEntityBreak(class_1309 entity, class_1304 slot) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            class_1799 item = entity.method_6118(slot).method_7972();
            if (item.method_31573(EnchantedTags.Items.ARMOR_POPPET_WHITELIST) && !item.method_31573(EnchantedTags.Items.ARMOR_POPPET_BLACKLIST)) {
                PriorityQueue<class_1799> poppetQueue = new PriorityQueue<class_1799>(new PoppetComparator());
                for (class_1799 itemStack : player.method_31548().field_7547) {
                    if (!(itemStack.method_7909() instanceof ItemProtectionPoppetItem) || !EnchantedItems.isArmourPoppet(itemStack.method_7909())) continue;
                    poppetQueue.add(itemStack);
                }
                boolean canceled = PoppetHelper.tryUseItemProtectionPoppetQueue(poppetQueue, player, item);
                if (!canceled) {
                    PriorityQueue<PoppetShelfSavedData.PoppetEntry> poppetEntryQueue = new PriorityQueue<PoppetShelfSavedData.PoppetEntry>(new PoppetEntryComparator());
                    for (PoppetShelfSavedData.PoppetEntry entry : PoppetShelfManager.getEntriesFor(player)) {
                        if (!EnchantedItems.isArmourPoppet(entry.item().method_7909())) continue;
                        poppetEntryQueue.add(entry);
                    }
                    canceled = PoppetHelper.tryUseItemProtectionPoppetEntryQueue(poppetEntryQueue, player, item);
                }
                if (canceled) {
                    player.method_5673(slot, item);
                }
            }
        }
    }

    private static class PoppetComparator
    implements Comparator<class_1799> {
        private PoppetComparator() {
        }

        @Override
        public int compare(class_1799 o1, class_1799 o2) {
            if (!(o1.method_7909() instanceof AbstractPoppetItem) || !(o1.method_7909() instanceof AbstractPoppetItem)) {
                throw new IllegalStateException("Non-poppet item inside the poppet use queue");
            }
            return Math.round(Math.signum(((AbstractPoppetItem)o1.method_7909()).failRate - ((AbstractPoppetItem)o2.method_7909()).failRate));
        }
    }

    private static class PoppetEntryComparator
    implements Comparator<PoppetShelfSavedData.PoppetEntry> {
        private PoppetEntryComparator() {
        }

        @Override
        public int compare(PoppetShelfSavedData.PoppetEntry o1, PoppetShelfSavedData.PoppetEntry o2) {
            return Math.round(Math.signum(((AbstractPoppetItem)o1.item().method_7909()).failRate - ((AbstractPoppetItem)o2.item().method_7909()).failRate));
        }
    }
}

