/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.common.jei.categories;

import com.favouriteless.enchanted.Enchanted;
import com.favouriteless.enchanted.api.rites.AbstractCreateItemRite;
import com.favouriteless.enchanted.common.init.registry.EnchantedItems;
import com.favouriteless.enchanted.common.jei.EnchantedJEITextures;
import com.favouriteless.enchanted.common.rites.CirclePart;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class RiteCategory
implements IRecipeCategory<AbstractCreateItemRite> {
    private final IJeiHelpers jeiHelpers;
    private final RecipeType<AbstractCreateItemRite> recipeTypeRite;
    private static final int GLYPH_SIZE = 110;
    private static final int START_RADIUS = 15;
    private static final int RADIUS_INCREMENT = 15;
    private final IDrawableStatic glyph_golden;
    private final List<IDrawableStatic> circles = new ArrayList<IDrawableStatic>();
    private final IDrawableAnimated arrow;

    public RiteCategory(IJeiHelpers jeiHelpers, RecipeType<AbstractCreateItemRite> recipeTypeRite) {
        this.jeiHelpers = jeiHelpers;
        this.recipeTypeRite = recipeTypeRite;
        IDrawableStatic arrow = jeiHelpers.getGuiHelper().createDrawable(Enchanted.location("textures/gui/witch_oven.png"), 176, 14, 24, 17);
        this.arrow = jeiHelpers.getGuiHelper().createAnimatedDrawable(arrow, 120, IDrawableAnimated.StartDirection.LEFT, false);
        this.glyph_golden = this.buildTexture(Enchanted.location("textures/gui/jei/gold_glyph.png"), 110, 110, jeiHelpers);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AbstractCreateItemRite rite, IFocusGroup focuses) {
        ArrayList<class_1799> itemList = new ArrayList<class_1799>();
        for (class_1792 item : rite.ITEMS_REQUIRED.keySet()) {
            itemList.add(new class_1799((class_1935)item, ((Integer)rite.ITEMS_REQUIRED.get(item)).intValue()));
        }
        int circleNum = 1;
        int itemsRemaining = itemList.size();
        while (itemsRemaining > 0) {
            int radius = 15 + (circleNum - 1) * 15;
            int limit = (int)Math.round(Math.pow(6.0, circleNum));
            int itemCount = Math.min(itemsRemaining, limit);
            for (int i = 0; i < itemCount; ++i) {
                class_1799 stack = (class_1799)itemList.get(0);
                itemList.remove(stack);
                double angle = Math.toRadians((double)i * (360.0 / (double)itemCount) + 180.0);
                int cx = (int)Math.round(Math.sin(-angle) * (double)radius) - 8;
                int cy = (int)Math.round(Math.cos(-angle) * (double)radius) - 8;
                builder.addSlot(RecipeIngredientRole.INPUT, 47 + cx, 60 + cy).addItemStack(stack);
                --itemsRemaining;
            }
            ++circleNum;
        }
        class_1799[] itemsOut = rite.getResultItems();
        int numRows = (int)Math.ceil((double)itemsOut.length / 3.0);
        int height = numRows * 17;
        int startX = 119;
        int startY = 61 - (int)Math.round((double)height / 2.0);
        for (int i = 0; i < itemsOut.length; ++i) {
            class_1799 stack = itemsOut[i];
            builder.addSlot(RecipeIngredientRole.OUTPUT, startX + i % 3 * 17, startY + i / 3 * 17).addItemStack(stack);
        }
        this.circles.clear();
        for (CirclePart circlePart : rite.CIRCLES_REQUIRED.keySet()) {
            class_2248 block;
            class_2960 textureLocation = EnchantedJEITextures.getCircleTextureLocation(circlePart, block = (class_2248)rite.CIRCLES_REQUIRED.get((Object)circlePart));
            if (textureLocation == null) continue;
            this.circles.add(this.buildTexture(textureLocation, 110, 110, this.jeiHelpers));
        }
    }

    public void draw(AbstractCreateItemRite rite, IRecipeSlotsView recipeSlotsView, class_4587 poseStack, double mouseX, double mouseY) {
        for (IDrawableStatic drawable : this.circles) {
            drawable.draw(poseStack, 0, 14);
        }
        this.glyph_golden.draw(poseStack, 0, 14);
        this.arrow.draw(poseStack, 95, 53);
        class_2960 riteName = rite.getType().getId();
        String nameText = class_2561.method_43471((String)("rite." + riteName.method_12836() + "." + riteName.method_12832())).getString();
        this.drawText(class_310.method_1551(), poseStack, nameText, 180, 0, -1);
        this.drawText(class_310.method_1551(), poseStack, "Required Altar Power : " + rite.POWER, 180, 112, -1);
        if (!rite.ENTITIES_REQUIRED.isEmpty() || rite.hasAdditionalRequirements()) {
            poseStack.method_22903();
            poseStack.method_22905(0.5f, 0.5f, 0.5f);
            this.drawText(class_310.method_1551(), poseStack, "Has additional requirements", 360, 18, -1);
            poseStack.method_22909();
        }
    }

    private void drawText(class_310 minecraft, class_4587 poseStack, String text, int x, int y, int mainColor) {
        int shadowColor = 0xFF000000 | (mainColor & 0xFCFCFC) >> 2;
        int width = minecraft.field_1772.method_1727(text);
        int cx = x / 2 - width / 2 - 1;
        minecraft.field_1772.method_1729(poseStack, text, (float)(cx + 1), (float)y, shadowColor);
    }

    private IDrawableStatic buildTexture(class_2960 resourceLocation, int width, int height, IJeiHelpers helper) {
        IDrawableBuilder builder = helper.getGuiHelper().drawableBuilder(resourceLocation, 0, 0, width, height);
        builder.setTextureSize(width, height);
        return builder.build();
    }

    public class_2561 getTitle() {
        return class_2561.method_43471((String)"jei.enchanted.circle_magic");
    }

    public IDrawable getBackground() {
        return this.jeiHelpers.getGuiHelper().createDrawable(Enchanted.location("textures/gui/jei/circle_magic.png"), 0, 0, 180, 120);
    }

    public IDrawable getIcon() {
        return this.jeiHelpers.getGuiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)EnchantedItems.CHALK_WHITE.get()));
    }

    public RecipeType<AbstractCreateItemRite> getRecipeType() {
        return this.recipeTypeRite;
    }
}

