/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.common.jei.categories;

import com.favouriteless.enchanted.Enchanted;
import com.favouriteless.enchanted.common.init.registry.EnchantedItems;
import com.favouriteless.enchanted.common.recipes.KettleRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class KettleCategory
implements IRecipeCategory<KettleRecipe> {
    private final RecipeType<KettleRecipe> type;
    private final IJeiHelpers jeiHelpers;
    private final int GUI_WIDTH = 140;
    private final IDrawableAnimated arrow;

    public KettleCategory(IJeiHelpers jeiHelpers, RecipeType<KettleRecipe> type) {
        this.jeiHelpers = jeiHelpers;
        this.type = type;
        IDrawableStatic arrow = jeiHelpers.getGuiHelper().createDrawable(Enchanted.location("textures/gui/witch_oven.png"), 176, 14, 24, 17);
        this.arrow = jeiHelpers.getGuiHelper().createAnimatedDrawable(arrow, 120, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public class_2561 getTitle() {
        return class_2561.method_43471((String)"jei.enchanted.kettle");
    }

    public void draw(KettleRecipe recipe, IRecipeSlotsView recipeSlotsView, class_4587 poseStack, double mouseX, double mouseY) {
        this.arrow.draw(poseStack, 85, 29);
        this.drawPowerCost(class_310.method_1551(), poseStack, "Required Altar Power : " + recipe.getPower(), -1);
    }

    private void drawPowerCost(class_310 minecraft, class_4587 poseStack, String text, int mainColor) {
        int shadowColor = 0xFF000000 | (mainColor & 0xFCFCFC) >> 2;
        int width = minecraft.field_1772.method_1727(text);
        int x = 70 - width / 2 - 1;
        int y = 55;
        minecraft.field_1772.method_1729(poseStack, text, (float)(x + 1), (float)y, shadowColor);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, KettleRecipe recipe, IFocusGroup focuses) {
        int offset = 0;
        for (class_1799 i : recipe.getItemsIn()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 5 + offset, 5).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)i);
            offset += 20;
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 110, 30).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.method_8110());
    }

    public IDrawable getBackground() {
        return this.jeiHelpers.getGuiHelper().createDrawable(Enchanted.location("textures/gui/jei/witch_cauldron.png"), 4, 4, 140, 70);
    }

    public IDrawable getIcon() {
        return this.jeiHelpers.getGuiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)EnchantedItems.KETTLE.get()));
    }

    public RecipeType<KettleRecipe> getRecipeType() {
        return this.type;
    }
}

