/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.common.jei.categories;

import com.favouriteless.enchanted.Enchanted;
import com.favouriteless.enchanted.common.init.registry.EnchantedItems;
import com.favouriteless.enchanted.common.recipes.DistillingRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_4587;

public class DistilleryCategory
implements IRecipeCategory<DistillingRecipe> {
    private final RecipeType<DistillingRecipe> type;
    private final IJeiHelpers helper;
    private final IDrawableAnimated bubbles;
    private final IDrawableAnimated arrow;

    public DistilleryCategory(IJeiHelpers helper, RecipeType<DistillingRecipe> type) {
        this.helper = helper;
        this.type = type;
        IDrawableStatic bubbles = helper.getGuiHelper().createDrawable(Enchanted.location("textures/gui/distillery.png"), 176, 0, 12, 29);
        this.bubbles = helper.getGuiHelper().createAnimatedDrawable(bubbles, 120, IDrawableAnimated.StartDirection.BOTTOM, false);
        IDrawableStatic arrow = helper.getGuiHelper().createDrawable(Enchanted.location("textures/gui/distillery.png"), 176, 29, 57, 61);
        this.arrow = helper.getGuiHelper().createAnimatedDrawable(arrow, 120, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void draw(DistillingRecipe recipe, IRecipeSlotsView recipeSlotsView, class_4587 stack, double mouseX, double mouseY) {
        this.bubbles.draw(stack, 88, 22);
        this.arrow.draw(stack, 65, 8);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DistillingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 28, 30).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((class_1799)recipe.getItemsIn().get(0)));
        int offset = 0;
        for (class_1799 i : recipe.getItemsIn()) {
            if (offset != 0) {
                builder.addSlot(RecipeIngredientRole.INPUT, 50, offset).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)i);
            }
            offset += 20;
        }
        offset = 0;
        for (class_1799 i : recipe.getItemsOut()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 123, 2 + offset).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)i);
            offset += 19;
        }
    }

    public class_2561 getTitle() {
        return class_2561.method_43471((String)"container.enchanted.distillery");
    }

    public IDrawable getBackground() {
        return this.helper.getGuiHelper().createDrawable(Enchanted.location("textures/gui/distillery.png"), 4, 5, 146, 75);
    }

    public IDrawable getIcon() {
        return this.helper.getGuiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)EnchantedItems.DISTILLERY.get()));
    }

    public RecipeType<DistillingRecipe> getRecipeType() {
        return this.type;
    }
}

