/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.common.init.registry;

import com.favouriteless.enchanted.Enchanted;
import com.favouriteless.enchanted.api.rites.AbstractRite;
import com.favouriteless.enchanted.common.rites.RiteType;
import com.favouriteless.enchanted.common.rites.binding.RiteBindingFamiliar;
import com.favouriteless.enchanted.common.rites.binding.RiteBindingTalisman;
import com.favouriteless.enchanted.common.rites.binding.RiteBindingTalismanCharged;
import com.favouriteless.enchanted.common.rites.binding.RiteBindingWaystone;
import com.favouriteless.enchanted.common.rites.binding.RiteBindingWaystoneCharged;
import com.favouriteless.enchanted.common.rites.binding.RiteBindingWaystoneDuplicate;
import com.favouriteless.enchanted.common.rites.binding.RiteBindingWaystoneDuplicateCharged;
import com.favouriteless.enchanted.common.rites.binding.RiteBindingWaystonePlayer;
import com.favouriteless.enchanted.common.rites.binding.RiteBindingWaystonePlayerCharged;
import com.favouriteless.enchanted.common.rites.curse.RiteCurseBlight;
import com.favouriteless.enchanted.common.rites.curse.RiteCurseMisfortune;
import com.favouriteless.enchanted.common.rites.curse.RiteCurseOverheating;
import com.favouriteless.enchanted.common.rites.curse.RiteCurseSinking;
import com.favouriteless.enchanted.common.rites.curse.RiteRemoveMisfortune;
import com.favouriteless.enchanted.common.rites.curse.RiteRemoveOverheating;
import com.favouriteless.enchanted.common.rites.curse.RiteRemoveSinking;
import com.favouriteless.enchanted.common.rites.entity.RiteImprisonment;
import com.favouriteless.enchanted.common.rites.entity.RiteSanctity;
import com.favouriteless.enchanted.common.rites.entity.RiteSummonEntity;
import com.favouriteless.enchanted.common.rites.entity.RiteSummonFamiliar;
import com.favouriteless.enchanted.common.rites.entity.RiteTranspositionPlayer;
import com.favouriteless.enchanted.common.rites.entity.RiteTranspositionPlayerBlooded;
import com.favouriteless.enchanted.common.rites.entity.protection.RiteProtection;
import com.favouriteless.enchanted.common.rites.entity.protection.RiteProtectionLarge;
import com.favouriteless.enchanted.common.rites.entity.protection.RiteProtectionTemporary;
import com.favouriteless.enchanted.common.rites.processing.RiteBroiling;
import com.favouriteless.enchanted.common.rites.processing.RiteBroilingCharged;
import com.favouriteless.enchanted.common.rites.processing.RiteChargingStone;
import com.favouriteless.enchanted.common.rites.processing.RiteInfusionBroom;
import com.favouriteless.enchanted.common.rites.world.RiteFertility;
import com.favouriteless.enchanted.common.rites.world.RiteFertilityCharged;
import com.favouriteless.enchanted.common.rites.world.RiteForest;
import com.favouriteless.enchanted.common.rites.world.RiteSkyWrath;
import com.favouriteless.enchanted.common.rites.world.RiteSkyWrathCharged;
import com.favouriteless.enchanted.common.rites.world.RiteTotalEclipse;
import com.favouriteless.enchanted.common.rites.world.RiteTotalEclipseCharged;
import com.favouriteless.enchanted.common.rites.world.RiteTranspositionIron;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public class RiteTypes {
    private static final Map<class_2960, RiteType<?>> RITE_TYPES = new HashMap();
    public static final RiteType<RiteBindingTalisman> BINDING_TALISMAN = RiteTypes.register("binding_talisman", RiteBindingTalisman::new);
    public static final RiteType<RiteBindingTalismanCharged> BINDING_TALISMAN_CHARGED = RiteTypes.register("binding_talisman_charged", RiteBindingTalismanCharged::new);
    public static final RiteType<RiteBindingWaystone> BINDING_WAYSTONE = RiteTypes.register("binding_waystone", RiteBindingWaystone::new);
    public static final RiteType<RiteBindingWaystoneCharged> BINDING_WAYSTONE_CHARGED = RiteTypes.register("binding_waystone_charged", RiteBindingWaystoneCharged::new);
    public static final RiteType<RiteBindingWaystoneDuplicate> BINDING_WAYSTONE_DUPLICATE = RiteTypes.register("binding_waystone_duplicate", RiteBindingWaystoneDuplicate::new);
    public static final RiteType<RiteBindingWaystoneDuplicateCharged> BINDING_WAYSTONE_DUPLICATE_CHARGED = RiteTypes.register("binding_waystone_duplicate_charged", RiteBindingWaystoneDuplicateCharged::new);
    public static final RiteType<RiteBindingWaystonePlayer> BINDING_WAYSTONE_PLAYER = RiteTypes.register("binding_waystone_player", RiteBindingWaystonePlayer::new);
    public static final RiteType<RiteBindingWaystonePlayerCharged> BINDING_WAYSTONE_PLAYER_CHARGED = RiteTypes.register("binding_waystone_player_charged", RiteBindingWaystonePlayerCharged::new);
    public static final RiteType<RiteBindingFamiliar> BINDING_FAMILIAR = RiteTypes.register("binding_familiar", RiteBindingFamiliar::new);
    public static final RiteType<RiteBroiling> BROILING = RiteTypes.register("broiling", RiteBroiling::new);
    public static final RiteType<RiteBroilingCharged> BROILING_CHARGED = RiteTypes.register("broiling_charged", RiteBroilingCharged::new);
    public static final RiteType<RiteChargingStone> CHARGING_STONE = RiteTypes.register("charging_stone", RiteChargingStone::new);
    public static final RiteType<RiteCurseBlight> CURSE_OF_BLIGHT = RiteTypes.register("curse_of_blight", RiteCurseBlight::new);
    public static final RiteType<RiteCurseMisfortune> CURSE_OF_MISFORTUNE = RiteTypes.register("curse_of_misfortune", RiteCurseMisfortune::new);
    public static final RiteType<RiteCurseOverheating> CURSE_OF_OVERHEATING = RiteTypes.register("curse_of_overheating", RiteCurseOverheating::new);
    public static final RiteType<RiteCurseSinking> CURSE_OF_SINKING = RiteTypes.register("curse_of_sinking", RiteCurseSinking::new);
    public static final RiteType<RiteFertility> FERTILITY = RiteTypes.register("fertility", RiteFertility::new);
    public static final RiteType<RiteFertilityCharged> FERTILITY_CHARGED = RiteTypes.register("fertility_charged", RiteFertilityCharged::new);
    public static final RiteType<RiteForest> FOREST = RiteTypes.register("forest", RiteForest::new);
    public static final RiteType<RiteImprisonment> IMPRISONMENT = RiteTypes.register("imprisonment", RiteImprisonment::new);
    public static final RiteType<RiteInfusionBroom> INFUSION_BROOM = RiteTypes.register("infusion_broom", RiteInfusionBroom::new);
    public static final RiteType<RiteProtection> PROTECTION = RiteTypes.register("protection", RiteProtection::new);
    public static final RiteType<RiteProtectionLarge> PROTECTION_LARGE = RiteTypes.register("protection_large", RiteProtectionLarge::new);
    public static final RiteType<RiteProtectionTemporary> PROTECTION_TEMPORARY = RiteTypes.register("protection_temporary", RiteProtectionTemporary::new);
    public static final RiteType<RiteRemoveMisfortune> REMOVE_MISFORTUNE = RiteTypes.register("remove_misfortune", RiteRemoveMisfortune::new);
    public static final RiteType<RiteRemoveOverheating> REMOVE_OVERHEATING = RiteTypes.register("remove_overheating", RiteRemoveOverheating::new);
    public static final RiteType<RiteRemoveSinking> REMOVE_SINKING = RiteTypes.register("remove_sinking", RiteRemoveSinking::new);
    public static final RiteType<RiteSanctity> SANCTITY = RiteTypes.register("sanctity", RiteSanctity::new);
    public static final RiteType<RiteSkyWrath> SKY_WRATH = RiteTypes.register("sky_wrath", RiteSkyWrath::new);
    public static final RiteType<RiteSkyWrathCharged> SKY_WRATH_CHARGED = RiteTypes.register("sky_wrath_charged", RiteSkyWrathCharged::new);
    public static final RiteType<RiteSummonEntity> SUMMONING_ENTITY = RiteTypes.register("summoning_entity", RiteSummonEntity::new);
    public static final RiteType<RiteSummonFamiliar> SUMMONING_FAMILIAR = RiteTypes.register("summoning_familiar", RiteSummonFamiliar::new);
    public static final RiteType<RiteTotalEclipse> TOTAL_ECLIPSE = RiteTypes.register("total_eclipse", RiteTotalEclipse::new);
    public static final RiteType<RiteTotalEclipseCharged> TOTAL_ECLIPSE_CHARGED = RiteTypes.register("total_eclipse_charged", RiteTotalEclipseCharged::new);
    public static final RiteType<RiteTranspositionIron> TRANSPOSITION_IRON = RiteTypes.register("transposition_iron", RiteTranspositionIron::new);
    public static final RiteType<RiteTranspositionPlayer> TRANSPOSITION_PLAYER = RiteTypes.register("transposition_player", RiteTranspositionPlayer::new);
    public static final RiteType<RiteTranspositionPlayerBlooded> TRANSPOSITION_PLAYER_BLOODED = RiteTypes.register("transposition_player_blooded", RiteTranspositionPlayerBlooded::new);

    public static <T extends AbstractRite> RiteType<T> register(class_2960 id, RiteType.RiteFactory<T> factory) {
        RiteType<T> riteType = new RiteType<T>(id, factory);
        RITE_TYPES.put(id, riteType);
        return riteType;
    }

    private static <T extends AbstractRite> RiteType<T> register(String id, RiteType.RiteFactory<T> factory) {
        return RiteTypes.register(Enchanted.location(id), factory);
    }

    public static RiteType<?> get(class_2960 id) {
        return RITE_TYPES.get(id);
    }

    public static AbstractRite getRiteAt(class_3218 level, class_2338 pos, UUID caster) {
        AbstractRite currentRite = null;
        int currentDiff = Integer.MAX_VALUE;
        for (RiteType<?> type : RITE_TYPES.values()) {
            Object rite = type.create(level, pos, caster);
            int diff = ((AbstractRite)rite).differenceAt((class_1937)level, pos);
            if (diff == -1 || diff >= currentDiff) continue;
            currentRite = (AbstractRite)rite;
            currentDiff = diff;
        }
        return currentRite;
    }

    public static AbstractRite getDefaultByName(class_2960 id) {
        RiteType<?> type = RITE_TYPES.get(id);
        return type != null ? (AbstractRite)type.create() : null;
    }

    public static Collection<RiteType<?>> getEntries() {
        return RITE_TYPES.values();
    }
}

