/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.common.init.registry;

import com.favouriteless.enchanted.common.altar.AltarPowerProvider;
import java.util.ArrayList;
import java.util.List;

public class PowerProviderRegistry<T> {
    private final List<AltarPowerProvider<T>> providers = new ArrayList<AltarPowerProvider<T>>();

    public void register(AltarPowerProvider<T> provider) {
        if (!this.providers.isEmpty()) {
            for (int i = 0; i < this.providers.size(); ++i) {
                AltarPowerProvider<T> oldProvider = this.providers.get(i);
                if (provider.getPower() > oldProvider.getPower()) {
                    this.providers.add(i, provider);
                    break;
                }
                if (provider.getPower() == oldProvider.getPower()) {
                    if (provider.getLimit() <= oldProvider.getLimit()) continue;
                    this.providers.add(i, provider);
                    break;
                }
                if (i != this.providers.size() - 1) continue;
                this.providers.add(provider);
            }
        } else {
            this.providers.add(provider);
        }
    }

    public AltarPowerProvider<T> get(T key) {
        for (AltarPowerProvider<T> provider : this.providers) {
            if (!provider.is(key)) continue;
            return provider;
        }
        return null;
    }

    public List<AltarPowerProvider<T>> getAll() {
        return this.providers;
    }

    public void reset() {
        this.providers.clear();
    }
}

