/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.common.init.registry;

import com.favouriteless.enchanted.Enchanted;
import com.favouriteless.enchanted.api.curses.Curse;
import com.favouriteless.enchanted.common.curses.CurseMisfortune;
import com.favouriteless.enchanted.common.curses.CurseOverheating;
import com.favouriteless.enchanted.common.curses.CurseSinking;
import com.favouriteless.enchanted.common.curses.CurseType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2960;

public class CurseTypes {
    private static final Map<class_2960, CurseType<?>> CURSE_TYPES = new HashMap();
    public static final CurseType<CurseMisfortune> MISFORTUNE = CurseTypes.register("misfortune", CurseMisfortune::new);
    public static final CurseType<CurseSinking> SINKING = CurseTypes.register("sinking", CurseSinking::new);
    public static final CurseType<CurseOverheating> OVERHEATING = CurseTypes.register("overheating", CurseOverheating::new);

    public static <T extends Curse> CurseType<T> register(class_2960 id, Supplier<T> curseSupplier) {
        CurseType<T> riteType = new CurseType<T>(id, curseSupplier);
        CURSE_TYPES.put(id, riteType);
        return riteType;
    }

    private static <T extends Curse> CurseType<T> register(String id, Supplier<T> curseSupplier) {
        return CurseTypes.register(Enchanted.location(id), curseSupplier);
    }

    public static Curse getInstance(class_2960 id) {
        CurseType<?> type = CURSE_TYPES.get(id);
        return type != null ? (Curse)type.create() : null;
    }
}

