/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.common.init;

import com.favouriteless.enchanted.api.LootExtension;
import com.favouriteless.enchanted.common.lootextensions.ArthanaLootExtension;
import com.favouriteless.enchanted.common.lootextensions.GrassLootExtension;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_47;

public class LootExtensions {
    private static final List<LootExtension> blockLootExtensions = new ArrayList<LootExtension>();
    private static final List<LootExtension> entityLootExtensions = new ArrayList<LootExtension>();

    public static void registerBlock(LootExtension extension) {
        if (blockLootExtensions.contains(extension)) {
            throw new IllegalArgumentException("Tried to register a duplicate Block loot extension.");
        }
        blockLootExtensions.add(extension);
    }

    public static void registerEntity(LootExtension extension) {
        if (entityLootExtensions.contains(extension)) {
            throw new IllegalArgumentException("Tried to register a duplicate Entity loot extension.");
        }
        entityLootExtensions.add(extension);
    }

    public static ObjectArrayList<class_1799> tryRollBlock(class_2680 state, class_47.class_48 builder) {
        ObjectArrayList out = new ObjectArrayList();
        for (LootExtension extension : blockLootExtensions) {
            if (!extension.canApply(state.method_26204())) continue;
            class_47 context = builder.method_312(class_181.field_1224, (Object)state).method_309(class_173.field_1172);
            class_3218 level = context.method_299();
            out.addAll((ObjectList)level.method_8503().method_3857().method_367(extension.getTable()).method_319(context));
        }
        return out;
    }

    public static void tryRollEntity(class_1309 entity, class_47.class_48 builder) {
        for (LootExtension extension : entityLootExtensions) {
            if (!extension.canApply(entity.method_5864())) continue;
            class_47 context = builder.method_309(class_173.field_1173);
            context.method_299().method_8503().method_3857().method_367(extension.getTable()).method_320(context, arg_0 -> ((class_1309)entity).method_5775(arg_0));
        }
    }

    static {
        LootExtensions.registerBlock(new GrassLootExtension());
        LootExtensions.registerEntity(new ArthanaLootExtension(class_1299.field_6108));
        LootExtensions.registerEntity(new ArthanaLootExtension(class_1299.field_6046));
        LootExtensions.registerEntity(new ArthanaLootExtension(class_1299.field_6055));
    }
}

