/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.common.blocks.entity;

import com.favouriteless.enchanted.api.power.IPowerConsumer;
import com.favouriteless.enchanted.api.power.IPowerProvider;
import com.favouriteless.enchanted.api.power.PowerHelper;
import com.favouriteless.enchanted.common.altar.SimplePowerPosHolder;
import com.favouriteless.enchanted.common.blocks.entity.ContainerBlockEntityBase;
import com.favouriteless.enchanted.common.init.registry.EnchantedBlockEntityTypes;
import com.favouriteless.enchanted.common.init.registry.EnchantedItems;
import com.favouriteless.enchanted.common.init.registry.EnchantedRecipeTypes;
import com.favouriteless.enchanted.common.menus.DistilleryMenu;
import com.favouriteless.enchanted.common.recipes.DistillingRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2363;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import org.jetbrains.annotations.NotNull;

public class DistilleryBlockEntity
extends ContainerBlockEntityBase
implements IPowerConsumer,
class_3908,
class_1278 {
    private static final int[] TOP_SLOTS = new int[]{1, 2};
    private static final int[] SIDE_SLOTS = new int[]{0};
    private static final int[] BOTTOM_SLOTS = new int[]{3, 4, 5, 6};
    private final class_1863.class_7266<class_1263, DistillingRecipe> recipeCheck;
    private final SimplePowerPosHolder posHolder;
    private boolean isBurning = false;
    private int cookProgress = 0;
    private int cookDuration = 200;
    private final class_3913 data = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> DistilleryBlockEntity.this.cookProgress;
                case 1 -> DistilleryBlockEntity.this.cookDuration;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    DistilleryBlockEntity.this.cookProgress = value;
                }
                case 1: {
                    DistilleryBlockEntity.this.cookDuration = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };

    public DistilleryBlockEntity(class_2338 pos, class_2680 state) {
        super(EnchantedBlockEntityTypes.DISTILLERY.get(), pos, state, (class_2371<class_1799>)class_2371.method_10213((int)7, (Object)class_1799.field_8037));
        this.posHolder = new SimplePowerPosHolder(pos);
        this.recipeCheck = class_1863.method_42302(EnchantedRecipeTypes.DISTILLING.get());
    }

    public static <T extends class_2586> void serverTick(class_1937 level, class_2338 blockPos, class_2680 blockState, T t) {
        if (t instanceof DistilleryBlockEntity) {
            DistillingRecipe recipe;
            boolean hasInput;
            DistilleryBlockEntity be = (DistilleryBlockEntity)t;
            IPowerProvider powerProvider = PowerHelper.tryGetPowerProvider(level, be.posHolder);
            boolean isCooking = false;
            boolean isBurning = be.isBurning;
            boolean bl = hasInput = !((class_1799)be.inventory.get(1)).method_7960() || !((class_1799)be.inventory.get(2)).method_7960();
            if (hasInput && powerProvider != null && be.canDistill(recipe = (DistillingRecipe)be.recipeCheck.method_42303((class_1263)be, level).orElse(null)) && powerProvider.tryConsumePower(10.0)) {
                isCooking = true;
                be.isBurning = true;
                if (++be.cookProgress == be.cookDuration) {
                    be.cookProgress = 0;
                    be.distill(recipe);
                }
            }
            if (!isCooking) {
                be.isBurning = false;
                if (be.cookProgress > 0) {
                    be.cookProgress = class_3532.method_15340((int)(be.cookProgress - 2), (int)0, (int)be.cookDuration);
                }
            }
            if (isBurning != be.isBurning) {
                level.method_8652(be.field_11867, (class_2680)level.method_8320(be.field_11867).method_11657((class_2769)class_2363.field_11105, (Comparable)Boolean.valueOf(be.isBurning)), 3);
            }
            be.method_5431();
        }
    }

    protected void distill(DistillingRecipe recipe) {
        if (recipe != null) {
            block0: for (class_1799 recipeItem : recipe.getItemsIn()) {
                for (int i = 0; i < 3; ++i) {
                    class_1799 inputItem = (class_1799)this.inventory.get(i);
                    if (!class_1799.method_31577((class_1799)recipeItem, (class_1799)inputItem) || inputItem.method_7947() < recipeItem.method_7947()) continue;
                    inputItem.method_7934(recipeItem.method_7947());
                    continue block0;
                }
            }
            class_2371<class_1799> itemsOut = recipe.getItemsOut();
            block2: for (class_1799 recipeItem : itemsOut) {
                int i;
                for (i = 3; i < this.inventory.size(); ++i) {
                    class_1799 outputItem = (class_1799)this.inventory.get(i);
                    if (!class_1799.method_31577((class_1799)recipeItem, (class_1799)outputItem)) continue;
                    int amount = Math.min(outputItem.method_7914() - outputItem.method_7947(), recipeItem.method_7947());
                    outputItem.method_7933(amount);
                    recipeItem.method_7934(amount);
                    if (recipeItem.method_7960()) break;
                }
                if (recipeItem.method_7960()) continue;
                for (i = 3; i < this.inventory.size(); ++i) {
                    if (!((class_1799)this.inventory.get(i)).method_7960()) continue;
                    this.inventory.set(i, (Object)recipeItem);
                    continue block2;
                }
            }
        }
    }

    private boolean canDistill(DistillingRecipe recipe) {
        if (recipe != null) {
            int i;
            ArrayList<class_1799> itemsOut = new ArrayList<class_1799>((Collection<class_1799>)recipe.getItemsOut());
            Iterator iterator = itemsOut.iterator();
            block0: while (iterator.hasNext()) {
                class_1799 recipeStack = (class_1799)iterator.next();
                for (i = 3; i < this.inventory.size(); ++i) {
                    class_1799 outStack = (class_1799)this.inventory.get(i);
                    if (!class_1799.method_31577((class_1799)recipeStack, (class_1799)outStack)) continue;
                    if (recipeStack.method_7947() + outStack.method_7947() <= outStack.method_7914()) {
                        iterator.remove();
                        continue block0;
                    }
                    recipeStack.method_7934(outStack.method_7914() - outStack.method_7947());
                }
            }
            int emptySpaces = 0;
            for (i = 3; i < this.inventory.size(); ++i) {
                if (!((class_1799)this.inventory.get(i)).method_7960()) continue;
                ++emptySpaces;
            }
            return emptySpaces >= itemsOut.size();
        }
        return false;
    }

    private static int getTotalCookTime(class_1937 level, DistilleryBlockEntity be) {
        return be.recipeCheck.method_42303((class_1263)be, level).map(DistillingRecipe::getCookTime).orElse(200);
    }

    @Override
    public class_2561 getDefaultName() {
        return class_2561.method_43471((String)"container.enchanted.distillery");
    }

    public class_1703 createMenu(int id, @NotNull class_1661 playerInventory, @NotNull class_1657 player) {
        return new DistilleryMenu(id, playerInventory, this, this.data);
    }

    @Override
    public void method_11007(@NotNull class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566("posHolder", (class_2520)this.posHolder.serialize());
        nbt.method_10556("isBurning", this.isBurning);
        nbt.method_10569("cookTime", this.cookProgress);
        nbt.method_10569("cookTimeTotal", this.cookDuration);
    }

    @Override
    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        this.posHolder.deserialize(nbt.method_10554("posHolder", 10));
        this.isBurning = nbt.method_10577("isBurning");
        this.cookProgress = nbt.method_10550("cookTime");
        this.cookDuration = nbt.method_10550("cookTimeTotal");
    }

    @Override
    @NotNull
    public IPowerConsumer.IPowerPosHolder getPosHolder() {
        return this.posHolder;
    }

    public int[] method_5494(@NotNull class_2350 face) {
        if (face == class_2350.field_11036) {
            return TOP_SLOTS;
        }
        if (face == class_2350.field_11033) {
            return BOTTOM_SLOTS;
        }
        return SIDE_SLOTS;
    }

    public boolean method_5492(int index, @NotNull class_1799 stack, @Nullable class_2350 face) {
        if (index < 3) {
            return index != 0 || stack.method_31574(EnchantedItems.CLAY_JAR.get());
        }
        return false;
    }

    public boolean method_5493(int index, @NotNull class_1799 stack, @Nullable class_2350 face) {
        return index > 2;
    }

    @Override
    public void method_5447(int index, @NotNull class_1799 stack) {
        boolean matching = !stack.method_7960() && class_1799.method_31577((class_1799)stack, (class_1799)((class_1799)this.inventory.get(index)));
        this.inventory.set(index, (Object)stack);
        if (index < 3 && !matching) {
            this.cookDuration = DistilleryBlockEntity.getTotalCookTime(this.field_11863, this);
            this.cookProgress = 0;
            this.method_5431();
        }
    }
}

