/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.common.blocks.entity;

import com.favouriteless.enchanted.api.power.IPowerConsumer;
import com.favouriteless.enchanted.api.rites.AbstractRite;
import com.favouriteless.enchanted.common.altar.SimplePowerPosHolder;
import com.favouriteless.enchanted.common.init.registry.EnchantedBlockEntityTypes;
import com.favouriteless.enchanted.common.init.registry.RiteTypes;
import com.favouriteless.enchanted.common.rites.RiteManager;
import net.minecraft.class_1160;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;

public class ChalkGoldBlockEntity
extends class_2586
implements IPowerConsumer {
    private final SimplePowerPosHolder posHolder;
    private AbstractRite currentRite = null;

    public ChalkGoldBlockEntity(class_2338 pos, class_2680 state) {
        super(EnchantedBlockEntityTypes.CHALK_GOLD.get(), pos, state);
        this.posHolder = new SimplePowerPosHolder(pos);
    }

    public void execute(class_2680 state, class_1937 _level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!_level.field_9236 && _level instanceof class_3218) {
            class_3218 level = (class_3218)_level;
            if (this.currentRite == null) {
                AbstractRite rite = RiteTypes.getRiteAt(level, pos, player.method_5667());
                if (rite != null) {
                    this.currentRite = rite;
                    RiteManager.addRite(this.currentRite);
                    this.currentRite.start();
                } else {
                    level.method_43128(null, (double)pos.method_10263(), (double)(pos.method_10264() + 1), (double)pos.method_10260(), class_3417.field_14708, class_3419.field_15250, 2.0f, 1.0f);
                }
            } else if (!this.currentRite.isStarting()) {
                this.currentRite.stopExecuting();
            }
        }
    }

    public static <T extends class_2586> void tick(class_1937 level, class_2338 pos, class_2680 blockState, T t) {
        if (t instanceof ChalkGoldBlockEntity) {
            ChalkGoldBlockEntity blockEntity = (ChalkGoldBlockEntity)t;
            if (level != null && blockEntity.currentRite != null) {
                double dx = (double)pos.method_10263() + Math.random();
                double dy = (double)pos.method_10264() + Math.random() * 0.3;
                double dz = (double)pos.method_10260() + Math.random();
                ((class_3218)level).method_14199((class_2394)new class_2390(new class_1160(0.99607843f, 0.36862746f, 0.36862746f), 1.0f), dx, dy, dz, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public void setRite(AbstractRite rite) {
        this.currentRite = rite;
    }

    public void clearRite() {
        this.currentRite = null;
    }

    public void stopRite() {
        this.currentRite.stopExecuting();
        this.clearRite();
    }

    public AbstractRite getRite() {
        return this.currentRite;
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566("posHolder", (class_2520)this.posHolder.serialize());
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.posHolder.deserialize(nbt.method_10554("posHolder", 10));
    }

    @Override
    @NotNull
    public IPowerConsumer.IPowerPosHolder getPosHolder() {
        return this.posHolder;
    }
}

