/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.common.blocks.entity;

import com.favouriteless.enchanted.Enchanted;
import com.favouriteless.enchanted.api.power.IPowerConsumer;
import com.favouriteless.enchanted.api.power.IPowerProvider;
import com.favouriteless.enchanted.api.power.PowerHelper;
import com.favouriteless.enchanted.client.client_handlers.blockentities.CauldronBlockEntityClientHandler;
import com.favouriteless.enchanted.client.particles.types.SimpleColouredParticleType;
import com.favouriteless.enchanted.common.CommonConfig;
import com.favouriteless.enchanted.common.altar.SimplePowerPosHolder;
import com.favouriteless.enchanted.common.blocks.cauldrons.CauldronBlockBase;
import com.favouriteless.enchanted.common.blocks.entity.ContainerBlockEntityBase;
import com.favouriteless.enchanted.common.init.registry.EnchantedParticleTypes;
import com.favouriteless.enchanted.common.recipes.CauldronTypeRecipe;
import com.favouriteless.enchanted.util.PlayerInventoryHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3922;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CauldronBlockEntity<T extends CauldronTypeRecipe>
extends ContainerBlockEntityBase
implements IPowerConsumer,
class_1278 {
    private final SimplePowerPosHolder posHolder;
    private final int fluidCapacity;
    private int fluidAmount = 0;
    private static final int WARMING_MAX = 80;
    private static final int BLENDING_MILLISECONDS = 500;
    private final int cookDuration;
    private List<T> potentialRecipes = new ArrayList<T>();
    protected class_1799 itemOut = class_1799.field_8037;
    protected int cookProgress = 0;
    protected int warmingUp = 0;
    public boolean isFailed = false;
    public boolean isComplete = false;
    private boolean firstTick = true;
    private boolean hasItems = false;
    private int targetRed = 63;
    private int targetGreen = 118;
    private int targetBlue = 228;
    private int startRed = this.targetRed;
    private int startGreen = this.targetGreen;
    private int startBlue = this.targetBlue;
    public long startTime = System.currentTimeMillis();

    public CauldronBlockEntity(class_2591<? extends CauldronBlockEntity<?>> type, class_2338 pos, class_2680 state, int bucketCapacity, int cookDuration) {
        super(type, pos, state, (class_2371<class_1799>)class_2371.method_10211());
        this.posHolder = new SimplePowerPosHolder(pos);
        this.fluidCapacity = bucketCapacity * 1000;
        this.cookDuration = cookDuration;
    }

    public static <T extends class_2586> void tick(class_1937 level, class_2338 pos, class_2680 blockState, T t) {
        if (t instanceof CauldronBlockEntity) {
            CauldronBlockEntity be = (CauldronBlockEntity)t;
            if (be.firstTick) {
                be.firstTick();
            }
            if (!level.field_9236) {
                boolean shouldUpdate = false;
                if (!be.isFailed && !be.isComplete) {
                    class_2680 stateBelow = level.method_8320(be.field_11867.method_10074());
                    if (CauldronBlockEntity.providesHeat(stateBelow) && be.fluidAmount == be.fluidCapacity) {
                        if (be.warmingUp < 80) {
                            ++be.warmingUp;
                            if (be.warmingUp == 80) {
                                shouldUpdate = true;
                            }
                        } else if (be.potentialRecipes.size() == 1 && ((CauldronTypeRecipe)be.potentialRecipes.get(0)).fullMatch(be)) {
                            if (be.cookProgress < be.cookDuration) {
                                ++be.cookProgress;
                                be.recalculateTargetColour();
                                if (be.cookProgress == 1 || be.cookProgress == be.cookDuration) {
                                    shouldUpdate = true;
                                }
                            } else {
                                CauldronTypeRecipe recipe = (CauldronTypeRecipe)be.potentialRecipes.get(0);
                                IPowerProvider powerProvider = PowerHelper.tryGetPowerProvider(level, be.getPosHolder());
                                if (recipe.getPower() <= 0) {
                                    be.setComplete();
                                } else if (powerProvider != null && powerProvider.tryConsumePower(recipe.getPower())) {
                                    be.setComplete();
                                } else {
                                    be.setFailed();
                                }
                                shouldUpdate = true;
                            }
                        }
                    } else {
                        if (be.hasItems) {
                            be.setFailed();
                        }
                        if (be.warmingUp > 0) {
                            shouldUpdate = true;
                        }
                        be.warmingUp = 0;
                    }
                }
                if (shouldUpdate) {
                    be.updateBlock();
                }
            } else if (blockState.method_26204() instanceof CauldronBlockBase) {
                long time = System.currentTimeMillis() - be.startTime;
                double waterY = be.getWaterY(blockState);
                if (be.isHot() && Enchanted.RANDOM.nextInt(10) > 2) {
                    double dx = (double)be.field_11867.method_10263() + 0.5 + (Math.random() - 0.5) * be.getWaterWidth();
                    double dy = (double)be.field_11867.method_10264() + waterY + 0.02;
                    double dz = (double)be.field_11867.method_10260() + 0.5 + (Math.random() - 0.5) * be.getWaterWidth();
                    level.method_8406((class_2394)new SimpleColouredParticleType.SimpleColouredData(EnchantedParticleTypes.BOILING.get(), be.getRed(time), be.getGreen(time), be.getBlue(time)), dx, dy, dz, 0.0, 0.0, 0.0);
                }
                if (!be.isFailed) {
                    if (!be.isComplete && be.cookProgress > 0 && be.cookProgress < be.cookDuration) {
                        be.handleCookParticles(time);
                    } else if (be.warmingUp == 80 && be.hasItems && Enchanted.RANDOM.nextInt(10) > 6) {
                        double xOffset = 0.5 + (Math.random() - 0.5) * be.getWaterWidth();
                        double zOffset = 0.5 + (Math.random() - 0.5) * be.getWaterWidth();
                        double dx = (double)be.field_11867.method_10263() + xOffset;
                        double dy = (double)be.field_11867.method_10264() + waterY;
                        double dz = (double)be.field_11867.method_10260() + zOffset;
                        class_243 velocity = new class_243(xOffset, 0.0, zOffset).method_1023(0.5, 0.0, 0.5).method_1029().method_1021((1.0 + Math.random()) * 0.06);
                        level.method_8406((class_2394)new SimpleColouredParticleType.SimpleColouredData(EnchantedParticleTypes.CAULDRON_BREW.get(), be.getRed(time), be.getGreen(time), be.getBlue(time)), dx, dy, dz, velocity.field_1352, (1.0 + Math.random()) * 0.06, velocity.field_1350);
                    }
                }
            }
        }
    }

    public double getWaterY(class_2680 state) {
        return this.getWaterStartY(state) + this.getWaterMaxHeight() * (double)this.fluidAmount / (double)this.fluidCapacity;
    }

    public abstract double getWaterStartY(class_2680 var1);

    public abstract double getWaterMaxHeight();

    public abstract double getWaterWidth();

    public abstract void handleCookParticles(long var1);

    public int getRed(long time) {
        return (int)Math.round(class_3532.method_16436((double)Math.min((double)time / 500.0, 1.0), (double)this.startRed, (double)this.targetRed));
    }

    public int getGreen(long time) {
        return (int)Math.round(class_3532.method_16436((double)Math.min((double)time / 500.0, 1.0), (double)this.startGreen, (double)this.targetGreen));
    }

    public int getBlue(long time) {
        return (int)Math.round(class_3532.method_16436((double)Math.min((double)time / 500.0, 1.0), (double)this.startBlue, (double)this.targetBlue));
    }

    private void setFailed() {
        this.itemOut = class_1799.field_8037;
        this.resetValues();
        this.isFailed = true;
        this.recalculateTargetColour();
    }

    private void setComplete() {
        this.itemOut = ((CauldronTypeRecipe)this.potentialRecipes.get(0)).method_8110().method_7972();
        this.resetValues();
        this.isComplete = true;
        this.recalculateTargetColour();
    }

    public void takeContents(class_1657 player) {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            if (this.isFailed) {
                this.setWater(0);
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_14834, class_3419.field_15248, 1.0f, 1.0f);
            } else {
                this.fluidAmount -= this.fluidCapacity / ((CauldronTypeRecipe)this.potentialRecipes.get(0)).method_8110().method_7947() + 1;
            }
            if (!this.itemOut.method_7960()) {
                if (player != null) {
                    PlayerInventoryHelper.tryGiveItem(player, this.isFailed ? new class_1799((class_1935)class_1802.field_8705) : new class_1799((class_1935)this.itemOut.method_7909()));
                } else {
                    this.field_11863.method_8649((class_1297)new class_1542(this.field_11863, (double)this.field_11867.method_10263(), (double)(this.field_11867.method_10264() + 1), (double)this.field_11867.method_10260(), new class_1799((class_1935)this.itemOut.method_7909())));
                }
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_14834, class_3419.field_15248, 1.0f, 1.0f);
            }
            this.itemOut.method_7934(1);
            if (this.itemOut.method_7960()) {
                this.inventory.clear();
                this.potentialRecipes.clear();
                this.resetValues();
            }
            this.recalculateTargetColour();
            this.updateBlock();
        }
    }

    private void resetValues() {
        this.isFailed = false;
        this.isComplete = false;
        this.cookProgress = 0;
    }

    public void addItem(class_1542 itemEntity) {
        if (itemEntity.method_5805()) {
            this.inventory.add((Object)itemEntity.method_6983());
            this.matchRecipes();
            if (this.potentialRecipes.isEmpty()) {
                if (((Boolean)CommonConfig.CAULDRON_ITEM_SPOIL.get()).booleanValue()) {
                    this.setFailed();
                } else {
                    this.inventory.remove((Object)itemEntity.method_6983());
                    this.matchRecipes();
                    return;
                }
            }
            if (this.field_11863 != null) {
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_14834, class_3419.field_15248, 1.0f, 1.0f);
            }
            itemEntity.method_5768();
            this.recalculateTargetColour();
            this.updateBlock();
        }
    }

    public boolean addWater(int amount) {
        if (!this.isComplete && !this.isFailed && this.fluidAmount < this.fluidCapacity) {
            this.fluidAmount = class_3532.method_15340((int)(this.fluidAmount + amount), (int)0, (int)this.fluidCapacity);
            this.method_5431();
            this.recalculateTargetColour();
            this.updateBlock();
            return true;
        }
        return false;
    }

    public boolean removeWater(int amount) {
        if (!this.isComplete && !this.isFailed && this.fluidAmount >= amount) {
            this.fluidAmount -= amount;
            this.method_5431();
            this.updateBlock();
            return true;
        }
        return false;
    }

    public void setWater(int amount) {
        this.fluidAmount = amount;
        this.method_5431();
        this.updateBlock();
    }

    public int getWater() {
        return this.fluidAmount;
    }

    public boolean isFull() {
        return this.fluidAmount >= this.fluidCapacity;
    }

    protected abstract void matchRecipes();

    public static boolean providesHeat(class_2680 state) {
        return state.method_26204() == class_2246.field_10036 || state.method_26204() == class_2246.field_22089 || state.method_26204() == class_2246.field_10164 || state.method_26204() == class_2246.field_17350 && (Boolean)state.method_11654((class_2769)class_3922.field_17352) != false || state.method_26204() == class_2246.field_23860 && (Boolean)state.method_11654((class_2769)class_3922.field_17352) != false || state.method_26204() == class_2246.field_10092;
    }

    private void recalculateTargetColour() {
        if (this.inventory.isEmpty()) {
            this.targetRed = 63;
            this.targetGreen = 118;
            this.targetBlue = 228;
        } else if (this.isComplete) {
            this.targetRed = ((CauldronTypeRecipe)this.potentialRecipes.get(0)).getFinalRed();
            this.targetGreen = ((CauldronTypeRecipe)this.potentialRecipes.get(0)).getFinalGreen();
            this.targetBlue = ((CauldronTypeRecipe)this.potentialRecipes.get(0)).getFinalBlue();
        } else if (this.isFailed) {
            this.targetRed = 150;
            this.targetGreen = 100;
            this.targetBlue = 47;
        } else if (!this.potentialRecipes.isEmpty() && this.cookProgress > 0) {
            this.targetRed = ((CauldronTypeRecipe)this.potentialRecipes.get(0)).getCookRed();
            this.targetGreen = ((CauldronTypeRecipe)this.potentialRecipes.get(0)).getCookGreen();
            this.targetBlue = ((CauldronTypeRecipe)this.potentialRecipes.get(0)).getCookBlue();
        } else {
            this.targetRed = Enchanted.RANDOM.nextInt(80);
            this.targetGreen = Enchanted.RANDOM.nextInt(80);
            this.targetBlue = Enchanted.RANDOM.nextInt(80);
        }
    }

    public boolean isHot() {
        return this.warmingUp == 80;
    }

    protected void setPotentialRecipes(List<T> potentialRecipes) {
        this.potentialRecipes = potentialRecipes;
    }

    public void firstTick() {
        this.firstTick = false;
        if (!this.field_11863.field_9236) {
            this.matchRecipes();
        } else {
            this.startRed = this.targetRed;
            this.startGreen = this.targetGreen;
            this.startBlue = this.targetBlue;
            CauldronBlockEntityClientHandler.startCauldronBubbling(this);
        }
    }

    @javax.annotation.Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public void saveBase(class_2487 nbt) {
        nbt.method_10569("waterAmount", this.fluidAmount);
        nbt.method_10569("targetRed", this.targetRed);
        nbt.method_10569("targetGreen", this.targetGreen);
        nbt.method_10569("targetBlue", this.targetBlue);
        nbt.method_10556("isFailed", this.isFailed);
        nbt.method_10556("isComplete", this.isComplete);
        nbt.method_10569("warmingUp", this.warmingUp);
        nbt.method_10569("cookProgress", this.cookProgress);
    }

    public void loadBase(class_2487 nbt) {
        this.setWater(nbt.method_10550("waterAmount"));
        this.isFailed = nbt.method_10577("isFailed");
        this.isComplete = nbt.method_10577("isComplete");
        this.warmingUp = nbt.method_10550("warmingUp");
        this.cookProgress = nbt.method_10550("cookProgress");
        int tr = nbt.method_10550("targetRed");
        int tg = nbt.method_10550("targetGreen");
        int tb = nbt.method_10550("targetBlue");
        if (tr != this.targetRed || tg != this.targetGreen || tb != this.targetBlue) {
            this.updateTargetColour(tr, tg, tb);
        }
    }

    @Override
    public void method_11007(@NotNull class_2487 nbt) {
        super.method_11007(nbt);
        this.saveBase(nbt);
        class_1262.method_5426((class_2487)nbt, (class_2371)this.inventory);
        if (this.itemOut != class_1799.field_8037) {
            class_2487 itemNbt = new class_2487();
            itemNbt.method_10582("item", class_2378.field_11142.method_10221((Object)this.itemOut.method_7909()).toString());
            itemNbt.method_10569("count", this.itemOut.method_7947());
            nbt.method_10566("itemOut", (class_2520)itemNbt);
        }
        nbt.method_10566("posHolder", (class_2520)this.posHolder.serialize());
    }

    @Override
    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        this.loadBase(nbt);
        if (nbt.method_10545("posHolder")) {
            this.posHolder.deserialize(nbt.method_10554("posHolder", 10));
        }
        if (nbt.method_10545("Items")) {
            class_2499 list = nbt.method_10554("Items", 10);
            for (int i = 0; i < list.size(); ++i) {
                class_2487 compoundnbt = list.method_10602(i);
                this.inventory.add((Object)class_1799.method_7915((class_2487)compoundnbt));
            }
            if (nbt.method_10545("itemOut")) {
                class_2487 itemNbt = (class_2487)nbt.method_10580("itemOut");
                this.itemOut = new class_1799((class_1935)class_2378.field_11142.method_10223(new class_2960(itemNbt.method_10558("item"))), itemNbt.method_10550("count"));
            }
        } else if (nbt.method_10545("hasItems")) {
            this.hasItems = nbt.method_10577("hasItems");
        }
    }

    @NotNull
    public class_2487 method_16887() {
        class_2487 nbt = new class_2487();
        this.saveBase(nbt);
        nbt.method_10556("hasItems", !this.inventory.isEmpty());
        return nbt;
    }

    public void updateTargetColour(int red, int green, int blue) {
        long time = System.currentTimeMillis();
        long timeSince = time - this.startTime;
        this.startRed = this.getRed(timeSince);
        this.startGreen = this.getGreen(timeSince);
        this.startBlue = this.getBlue(timeSince);
        this.targetRed = red;
        this.targetGreen = green;
        this.targetBlue = blue;
        this.startTime = time;
    }

    @Override
    public class_2371<class_1799> getDroppableInventory() {
        return class_2371.method_10211();
    }

    @Override
    @NotNull
    public IPowerConsumer.IPowerPosHolder getPosHolder() {
        return this.posHolder;
    }

    public int[] method_5494(class_2350 direction) {
        return new int[0];
    }

    public boolean method_5492(int i, class_1799 itemStack, @Nullable class_2350 direction) {
        return false;
    }

    public boolean method_5493(int i, class_1799 itemStack, class_2350 direction) {
        return false;
    }
}

