/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.common.blocks.entity;

import com.favouriteless.enchanted.Enchanted;
import com.favouriteless.enchanted.api.ISerializable;
import com.favouriteless.enchanted.api.power.IPowerConsumer;
import com.favouriteless.enchanted.api.power.IPowerProvider;
import com.favouriteless.enchanted.common.CommonConfig;
import com.favouriteless.enchanted.common.altar.AltarPowerProvider;
import com.favouriteless.enchanted.common.altar.AltarStateObserver;
import com.favouriteless.enchanted.common.blocks.altar.AltarBlock;
import com.favouriteless.enchanted.common.init.EnchantedData;
import com.favouriteless.enchanted.common.init.EnchantedTags;
import com.favouriteless.enchanted.common.init.registry.EnchantedBlockEntityTypes;
import com.favouriteless.enchanted.common.menus.AltarMenu;
import com.favouriteless.stateobserver.StateObserverManager;
import com.favouriteless.stateobserver.api.StateObserver;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_6862;

public class AltarBlockEntity
extends class_2586
implements class_3908,
IPowerProvider {
    private final double rechargeRate = (Double)CommonConfig.ALTAR_BASE_RECHARGE.get();
    private final AltarBlockData altarBlockData = new AltarBlockData();
    private final AltarUpgradeData altarUpgradeData = new AltarUpgradeData();
    private double rechargeMultiplier = 1.0;
    private double powerMultiplier = 1.0;
    private double maxPower;
    private double currentPower;
    private final class_3913 fields = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> (int)Math.round(AltarBlockEntity.this.currentPower);
                case 1 -> (int)Math.round(AltarBlockEntity.this.maxPower);
                case 2 -> (int)Math.round(AltarBlockEntity.this.rechargeMultiplier);
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    AltarBlockEntity.this.currentPower = value;
                }
                case 1: {
                    AltarBlockEntity.this.maxPower = value;
                }
                case 2: {
                    AltarBlockEntity.this.rechargeMultiplier = value;
                }
            }
        }

        public int method_17389() {
            return 3;
        }
    };
    private AltarStateObserver stateObserver = null;
    private boolean facingX;
    private class_243 centerPos;
    private boolean firstLoad = true;
    private int ticksAlive = 0;
    private boolean firstTick = true;

    public AltarBlockEntity(class_2338 pos, class_2680 state) {
        super(EnchantedBlockEntityTypes.ALTAR.get(), pos, state);
    }

    public static <T extends class_2586> void tick(class_1937 level, class_2338 pos, class_2680 state, T t) {
        if (t instanceof AltarBlockEntity) {
            AltarBlockEntity be = (AltarBlockEntity)t;
            if (level != null && !level.field_9236) {
                if (be.firstTick) {
                    be.firstTick();
                }
                if (be.ticksAlive % 20 == 0) {
                    be.stateObserver.checkChanges();
                }
                if (be.currentPower <= be.maxPower) {
                    be.currentPower += be.rechargeRate * be.rechargeMultiplier;
                }
                if (be.currentPower > be.maxPower) {
                    be.currentPower = be.maxPower;
                }
                ++be.ticksAlive;
            }
        }
    }

    public void firstTick() {
        if (this.stateObserver == null) {
            this.stateObserver = (AltarStateObserver)StateObserverManager.getObserver((class_1937)this.field_11863, (class_2338)this.field_11867, AltarStateObserver.class);
        }
        if (this.stateObserver == null) {
            int range = (Integer)CommonConfig.ALTAR_RANGE.get();
            this.stateObserver = (AltarStateObserver)StateObserverManager.createObserver((StateObserver)new AltarStateObserver(this.field_11863, this.field_11867, range + 4, range + 4, range + 4));
        }
        this.facingX = (Boolean)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)AltarBlock.FACING_X);
        class_243 class_2432 = this.centerPos = this.facingX ? class_243.method_24954((class_2382)this.field_11867).method_1031(1.0, 0.0, 0.5) : class_243.method_24954((class_2382)this.field_11867).method_1031(0.5, 0.0, 1.0);
        if (this.firstLoad) {
            this.recalculatePower();
        }
        this.firstTick = false;
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10549("currentPower", this.currentPower);
        nbt.method_10549("maxPower", this.maxPower);
        nbt.method_10549("powerMultiplier", this.powerMultiplier);
        nbt.method_10549("rechargeMultiplier", this.rechargeMultiplier);
        nbt.method_10566("blockData", (class_2520)this.altarBlockData.serialize());
        nbt.method_10566("upgradeData", (class_2520)this.altarUpgradeData.serialize());
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.setMaxPower(nbt.method_10574("maxPower"));
        this.setMaxPower(nbt.method_10574("maxPower"));
        this.currentPower = nbt.method_10574("currentPower");
        this.powerMultiplier = nbt.method_10574("powerMultiplier");
        this.rechargeMultiplier = nbt.method_10574("rechargeMultiplier");
        if (nbt.method_10545("blockData") && nbt.method_10545("upgradeData")) {
            this.altarBlockData.deserialize((class_2487)nbt.method_10580("blockData"));
            this.altarUpgradeData.deserialize((class_2487)nbt.method_10580("upgradeData"));
        } else {
            Enchanted.LOG.info(String.format("Failed to load power block data for altar at x:%s y:%s z:%s", this.method_11016().method_10263(), this.method_11016().method_10264(), this.method_11016().method_10260()));
        }
        this.firstLoad = false;
    }

    private void recalculatePower() {
        this.recalculateUpgrades();
        this.recalculateBlocks();
    }

    private void recalculateUpgrades() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            class_2338 minPos = this.field_11867.method_10084();
            class_2338 maxPos = this.facingX ? minPos.method_10069(2, 0, 1) : minPos.method_10069(1, 0, 2);
            this.altarUpgradeData.reset();
            for (class_2338 pos : class_2338.method_10097((class_2338)minPos, (class_2338)maxPos)) {
                this.altarUpgradeData.addBlock(this.field_11863.method_8320(pos).method_26204());
            }
            this.powerMultiplier = this.altarUpgradeData.calculatePowerMultiplier();
            this.rechargeMultiplier = this.altarUpgradeData.calculateRechargeMultiplier();
            this.method_5431();
        }
    }

    private void recalculateBlocks() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            int range = (Integer)CommonConfig.ALTAR_RANGE.get();
            class_2338 startingPos = this.facingX ? new class_2338(this.centerPos.method_1031((double)(-(range + 4)), (double)(-(range + 2)), (double)(-(range + 2)))) : new class_2338(this.centerPos.method_1031((double)(-(range + 2)), (double)(-(range + 2)), (double)(-(range + 4))));
            this.altarBlockData.reset();
            for (int x = 0; x < (range + 2) * 2; ++x) {
                for (int y = 0; y < (range + 2) * 2; ++y) {
                    for (int z = 0; z < (range + 2) * 2; ++z) {
                        class_2338 currentPos = startingPos.method_10069(x, y, z);
                        if (!this.posWithinRange(currentPos, range)) continue;
                        class_2586 class_25862 = this.field_11863.method_8321(currentPos);
                        if (class_25862 instanceof IPowerConsumer) {
                            IPowerConsumer consumer = (IPowerConsumer)class_25862;
                            consumer.getPosHolder().add(this.field_11867);
                        }
                        this.addBlock(this.field_11863.method_8320(currentPos).method_26204());
                    }
                }
            }
        }
    }

    public boolean posWithinRange(class_2338 pos, int range) {
        if (this.field_11863 != null) {
            double rx = this.facingX ? (double)(range + 1) : (double)range;
            double rz = this.facingX ? (double)range : (double)(range + 1);
            double dx = (double)pos.method_10263() - this.centerPos.field_1352;
            double dy = (double)pos.method_10264() - this.centerPos.field_1351;
            double dz = (double)pos.method_10260() - this.centerPos.field_1350;
            return dx * dx / (rx * rx) + dy * dy / (double)(range * range) + dz * dz / (rz * rz) <= 1.0;
        }
        return false;
    }

    public double distanceTo(class_2338 pos) {
        double dx = (double)pos.method_10263() - this.centerPos.field_1352;
        double dy = (double)pos.method_10264() - this.centerPos.field_1351;
        double dz = (double)pos.method_10260() - this.centerPos.field_1350;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public boolean posIsUpgrade(class_2338 pos) {
        if (this.field_11863 != null) {
            int zMax;
            int xMax;
            if (this.facingX) {
                xMax = 2;
                zMax = 1;
            } else {
                xMax = 1;
                zMax = 2;
            }
            int xOffset = pos.method_10263() - this.field_11867.method_10263();
            int zOffset = pos.method_10260() - this.field_11867.method_10260();
            boolean withinX = xOffset >= 0 && xOffset <= xMax;
            boolean withinZ = zOffset >= 0 && zOffset <= zMax;
            return pos.method_10264() == this.field_11867.method_10264() + 1 && withinX && withinZ;
        }
        return false;
    }

    public void setMaxPower(double power) {
        this.maxPower = power;
        if (this.currentPower > this.maxPower) {
            this.currentPower = this.maxPower;
        }
        this.method_5431();
    }

    public void addBlock(class_2248 block) {
        this.maxPower += this.altarBlockData.addBlock(block) * this.powerMultiplier;
        this.method_5431();
    }

    public void removeBlock(class_2248 block) {
        this.maxPower -= this.altarBlockData.removeBlock(block) * this.powerMultiplier;
        if (this.currentPower > this.maxPower) {
            this.currentPower = this.maxPower;
        }
        this.method_5431();
    }

    public void addUpgrade(class_2248 block) {
        if (this.altarUpgradeData.addBlock(block)) {
            double newPowerMultiplier = this.altarUpgradeData.calculatePowerMultiplier();
            if (newPowerMultiplier != this.powerMultiplier) {
                this.powerMultiplier = newPowerMultiplier;
                this.setMaxPower(this.altarBlockData.calculatePower(this.powerMultiplier));
            }
            this.rechargeMultiplier = this.altarUpgradeData.calculateRechargeMultiplier();
            this.method_5431();
        }
    }

    public void removeUpgrade(class_2248 block) {
        if (this.altarUpgradeData.removeBlock(block)) {
            double newPowerMultiplier = this.altarUpgradeData.calculatePowerMultiplier();
            if (newPowerMultiplier != this.powerMultiplier) {
                this.powerMultiplier = newPowerMultiplier;
                this.setMaxPower(this.altarBlockData.calculatePower(this.powerMultiplier));
            }
            this.rechargeMultiplier = this.altarUpgradeData.calculateRechargeMultiplier();
            this.method_5431();
        }
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.enchanted.altar");
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 playerInventory, class_1657 player) {
        return new AltarMenu(id, this, this.fields);
    }

    @Override
    public boolean tryConsumePower(double amount) {
        if (this.currentPower > amount) {
            this.currentPower -= amount;
            return true;
        }
        return false;
    }

    public static class AltarBlockData
    implements ISerializable<class_2487> {
        public Map<class_2248, Integer> blockCounts = new HashMap<class_2248, Integer>();
        public Map<class_6862<class_2248>, Integer> tagCounts = new HashMap<class_6862<class_2248>, Integer>();

        public AltarBlockData() {
            for (AltarPowerProvider<class_2248> altarPowerProvider : EnchantedData.POWER_BLOCKS.getAll()) {
                this.blockCounts.put(altarPowerProvider.getKey(), 0);
            }
            for (AltarPowerProvider<class_2248> altarPowerProvider : EnchantedData.POWER_TAGS.getAll()) {
                this.tagCounts.put((class_6862<class_2248>)((class_6862)altarPowerProvider.getKey()), 0);
            }
        }

        @Override
        public class_2487 serialize() {
            class_2487 nbt = new class_2487();
            class_2487 blockNbt = new class_2487();
            class_2487 tagNbt = new class_2487();
            for (class_2248 class_22482 : this.blockCounts.keySet()) {
                blockNbt.method_10569(class_2378.field_11146.method_10221((Object)class_22482).toString(), this.blockCounts.get(class_22482).intValue());
            }
            for (class_6862 class_68622 : this.tagCounts.keySet()) {
                tagNbt.method_10569(class_68622.comp_327().toString(), this.tagCounts.get(class_68622).intValue());
            }
            nbt.method_10566("blocksAmount", (class_2520)blockNbt);
            nbt.method_10566("tagsAmount", (class_2520)tagNbt);
            return nbt;
        }

        @Override
        public void deserialize(class_2487 nbt) {
            class_2487 blockNbt = (class_2487)nbt.method_10580("blocksAmount");
            class_2487 tagNbt = (class_2487)nbt.method_10580("tagsAmount");
            for (String name : blockNbt.method_10541()) {
                this.blockCounts.put((class_2248)class_2378.field_11146.method_10223(new class_2960(name)), blockNbt.method_10550(name));
            }
            for (String name : tagNbt.method_10541()) {
                this.tagCounts.put(EnchantedTags.createBlockTag(new class_2960(name)), tagNbt.method_10550(name));
            }
        }

        public double addBlock(class_2248 block) {
            Integer amount = this.blockCounts.get(block);
            if (amount == null) {
                for (AltarPowerProvider<class_6862<class_2248>> provider : EnchantedData.POWER_TAGS.getAll()) {
                    if (!block.method_40142().method_40220(provider.getKey())) continue;
                    amount = this.tagCounts.get(provider.getKey());
                    this.tagCounts.replace(provider.getKey(), this.tagCounts.get(provider.getKey()) + 1);
                    return amount < provider.getLimit() ? (double)provider.getPower() : 0.0;
                }
            }
            if (amount == null) {
                return 0.0;
            }
            AltarPowerProvider<class_2248> provider = EnchantedData.POWER_BLOCKS.get(block);
            this.blockCounts.replace(block, amount + 1);
            return amount < provider.getLimit() ? (double)provider.getPower() : 0.0;
        }

        public double removeBlock(class_2248 block) {
            Integer amount = this.blockCounts.get(block);
            if (amount == null) {
                for (AltarPowerProvider<class_6862<class_2248>> provider : EnchantedData.POWER_TAGS.getAll()) {
                    if (!block.method_40142().method_40220(provider.getKey())) continue;
                    amount = this.tagCounts.get(provider.getKey());
                    this.tagCounts.replace(provider.getKey(), this.tagCounts.get(provider.getKey()) - 1);
                    return amount > provider.getLimit() ? 0.0 : (double)provider.getPower();
                }
            }
            if (amount == null) {
                return 0.0;
            }
            AltarPowerProvider<class_2248> provider = EnchantedData.POWER_BLOCKS.get(block);
            this.blockCounts.replace(block, amount - 1);
            return amount > provider.getLimit() ? 0.0 : (double)provider.getPower();
        }

        public double calculatePower(double powerMultiplier) {
            AltarPowerProvider<class_2248> powerProvider;
            double newPower = 0.0;
            for (class_2248 class_22482 : this.blockCounts.keySet()) {
                powerProvider = EnchantedData.POWER_BLOCKS.get(class_22482);
                if (powerProvider == null) {
                    this.blockCounts.remove(powerProvider.getKey());
                    break;
                }
                newPower += (double)(Math.max(0, Math.min(powerProvider.getLimit(), this.blockCounts.get(class_22482))) * powerProvider.getPower()) * powerMultiplier;
            }
            for (class_6862 class_68622 : this.tagCounts.keySet()) {
                powerProvider = EnchantedData.POWER_TAGS.get((class_6862<class_2248>)class_68622);
                if (powerProvider == null) {
                    this.tagCounts.remove(powerProvider.getKey());
                    break;
                }
                newPower += (double)(Math.max(0, Math.min(powerProvider.getLimit(), this.tagCounts.get(class_68622))) * powerProvider.getPower()) * powerMultiplier;
            }
            return newPower;
        }

        public void reset() {
            this.blockCounts.replaceAll((key, value) -> {
                value = 0;
                return value;
            });
            this.tagCounts.replaceAll((key, value) -> {
                value = 0;
                return value;
            });
        }
    }

    public static class AltarUpgradeData
    implements ISerializable<class_2487> {
        public final Map<String, Map<AltarUpgrade, Integer>> upgradesByType = new HashMap<String, Map<AltarUpgrade, Integer>>();

        public AltarUpgradeData() {
            for (AltarUpgrade upgrade : EnchantedData.ALTAR_UPGRADES.getAll()) {
                Map<AltarUpgrade, Integer> upgrades;
                String type = upgrade.type().toString();
                if (!this.upgradesByType.containsKey(type)) {
                    this.upgradesByType.put(type, new HashMap());
                }
                if ((upgrades = this.upgradesByType.get(type)).containsKey(upgrade)) continue;
                upgrades.put(upgrade, 0);
            }
        }

        @Override
        public class_2487 serialize() {
            class_2487 nbt = new class_2487();
            for (String type : this.upgradesByType.keySet()) {
                class_2487 typeTag = new class_2487();
                Map<AltarUpgrade, Integer> map = this.upgradesByType.get(type);
                for (AltarUpgrade upgrade : map.keySet()) {
                    typeTag.method_10569(class_2378.field_11146.method_10221((Object)upgrade.block()).toString(), map.get(upgrade).intValue());
                }
                nbt.method_10566(type, (class_2520)typeTag);
            }
            return nbt;
        }

        @Override
        public void deserialize(class_2487 nbt) {
            for (String type : nbt.method_10541()) {
                this.upgradesByType.get(type).replaceAll((key, value) -> nbt.method_10550(class_2378.field_11146.method_10221((Object)key.block()).toString()));
            }
        }

        public boolean addBlock(class_2248 block) {
            AltarUpgrade upgrade = this.getUpgrade(block);
            if (upgrade == null) {
                return false;
            }
            String type = upgrade.type().toString();
            this.upgradesByType.get(type).put(upgrade, this.upgradesByType.get(type).get(upgrade) + 1);
            return true;
        }

        public boolean removeBlock(class_2248 block) {
            AltarUpgrade upgrade = this.getUpgrade(block);
            if (upgrade == null) {
                return false;
            }
            String type = upgrade.type().toString();
            int count = this.upgradesByType.get(type).get(upgrade);
            if (count > 0) {
                this.upgradesByType.get(type).put(upgrade, count - 1);
            }
            return true;
        }

        private AltarUpgrade getUpgrade(class_2248 block) {
            for (AltarUpgrade upgrade : EnchantedData.ALTAR_UPGRADES.getAll()) {
                if (upgrade.block() != block) continue;
                return upgrade;
            }
            return null;
        }

        public double calculatePowerMultiplier() {
            double multiplier = 1.0;
            for (String type : this.upgradesByType.keySet()) {
                AltarUpgrade highestPriority = null;
                Map<AltarUpgrade, Integer> map = this.upgradesByType.get(type);
                for (AltarUpgrade upgrade : map.keySet()) {
                    if (map.get(upgrade) <= 0) continue;
                    if (highestPriority == null) {
                        highestPriority = upgrade;
                        continue;
                    }
                    if (highestPriority.priority() >= upgrade.priority()) continue;
                    highestPriority = upgrade;
                }
                if (highestPriority == null) continue;
                multiplier += highestPriority.powerMultiplier();
            }
            return multiplier;
        }

        public double calculateRechargeMultiplier() {
            double multiplier = 1.0;
            for (String type : this.upgradesByType.keySet()) {
                AltarUpgrade highestPriority = null;
                Map<AltarUpgrade, Integer> map = this.upgradesByType.get(type);
                for (AltarUpgrade upgrade : map.keySet()) {
                    if (map.get(upgrade) <= 0) continue;
                    if (highestPriority == null) {
                        highestPriority = upgrade;
                        continue;
                    }
                    if (highestPriority.priority() >= upgrade.priority()) continue;
                    highestPriority = upgrade;
                }
                if (highestPriority == null) continue;
                multiplier += highestPriority.rechargeMultiplier();
            }
            return multiplier;
        }

        public void reset() {
            for (Map<AltarUpgrade, Integer> map : this.upgradesByType.values()) {
                map.replaceAll((key, value) -> 0);
            }
        }
    }

    public record AltarUpgrade(class_2960 type, class_2248 block, double rechargeMultiplier, double powerMultiplier, int priority) {
    }
}

