/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.client.render.poppet;

import com.favouriteless.enchanted.client.render.poppet.PoppetAnimation;
import com.favouriteless.enchanted.common.poppet.PoppetHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1160;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_4587;

public class PoppetAnimationManager {
    private static final List<PoppetAnimation> ACTIVE_ANIMATIONS = new ArrayList<PoppetAnimation>();
    private static final class_1160 DIFFUSE_LIGHT_0 = (class_1160)class_156.method_654((Object)new class_1160(0.2f, 0.24f, -0.7f), class_1160::method_4952);
    private static final class_1160 DIFFUSE_LIGHT_1 = (class_1160)class_156.method_654((Object)new class_1160(-0.2f, 0.24f, 0.7f), class_1160::method_4952);

    public static void startAnimation(PoppetHelper.PoppetResult result, class_1799 itemStack) {
        switch (result) {
            case SUCCESS: 
            case SUCCESS_BREAK: {
                PoppetAnimationManager.startAnimation(new PoppetAnimation(itemStack, 120));
            }
        }
    }

    public static void startAnimation(PoppetAnimation animation) {
        ACTIVE_ANIMATIONS.add(animation);
    }

    public static void tick() {
        for (PoppetAnimation animation : ACTIVE_ANIMATIONS) {
            animation.tick();
        }
        ACTIVE_ANIMATIONS.removeIf(anim -> anim.ticks <= 0);
    }

    public static void render(class_4587 matrixStack, float partialTicks, int widthScaled, int heightScaled) {
        RenderSystem.enableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.setupGui3DDiffuseLighting((class_1160)DIFFUSE_LIGHT_0, (class_1160)DIFFUSE_LIGHT_1);
        for (PoppetAnimation animation : ACTIVE_ANIMATIONS) {
            animation.render(matrixStack, partialTicks, widthScaled, heightScaled);
        }
        RenderSystem.enableCull();
        RenderSystem.disableDepthTest();
    }
}

