/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.client.render.blockentity;

import com.favouriteless.enchanted.common.blocks.cauldrons.CauldronBlockBase;
import com.favouriteless.enchanted.common.blocks.entity.CauldronBlockEntity;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_1921;
import net.minecraft.class_241;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_827;

public class CauldronWaterRenderer<T extends CauldronBlockEntity<?>>
implements class_827<T> {
    public static final class_2960 WATER_TEXTURE = new class_2960("minecraft:textures/block/water_still.png");
    private static final int FRAME_TIME = 2;
    private final CauldronQuad quad;

    public CauldronWaterRenderer(int waterWidth) {
        this.quad = new CauldronQuad((float)waterWidth / 2.0f - 0.01f);
    }

    public void render(T blockEntity, float partialTicks, class_4587 poseStack, class_4597 renderBuffer, int combinedLight, int combinedOverlay) {
        class_2680 state = blockEntity.method_10997().method_8320(blockEntity.method_11016());
        if (state.method_26204() instanceof CauldronBlockBase) {
            long ticks = blockEntity.method_10997().method_8510();
            int waterAmount = ((CauldronBlockEntity)blockEntity).getWater();
            if (waterAmount > 0) {
                double waterQuadHeight = ((CauldronBlockEntity)blockEntity).getWaterY(state);
                poseStack.method_22903();
                poseStack.method_22904(0.5, waterQuadHeight, 0.5);
                class_4588 vertexBuilder = renderBuffer.getBuffer(class_1921.method_23689((class_2960)WATER_TEXTURE));
                long time = System.currentTimeMillis() - ((CauldronBlockEntity)blockEntity).startTime;
                this.quad.render(poseStack.method_23760(), vertexBuilder, ((CauldronBlockEntity)blockEntity).getRed(time), ((CauldronBlockEntity)blockEntity).getGreen(time), ((CauldronBlockEntity)blockEntity).getBlue(time), 160, 0.0f, 0.03125f * ((float)(ticks / 2L) % 32.0f), combinedLight);
                poseStack.method_22909();
            }
        }
    }

    public static class CauldronQuad {
        private static final class_241[] uvs = new class_241[]{new class_241(1.0f, 0.0f), new class_241(0.0f, 0.0f), new class_241(0.0f, 0.03125f), new class_241(1.0f, 0.03125f)};
        private final class_1160[] positions;

        public CauldronQuad(float apothem) {
            this.positions = new class_1160[]{new class_1160(apothem, 0.0f, -apothem), new class_1160(-apothem, 0.0f, -apothem), new class_1160(-apothem, 0.0f, apothem), new class_1160(apothem, 0.0f, apothem)};
        }

        public void render(class_4587.class_4665 pose, class_4588 vertexBuilder, int red, int green, int blue, int alpha, float uOffset, float vOffset, int combinedLight) {
            class_1159 poseMatrix = pose.method_23761();
            for (int i = 0; i < 4; ++i) {
                class_1160 localPos = this.positions[i];
                class_241 quadUvs = uvs[i];
                class_1162 posVector = new class_1162(localPos.method_4943() / 16.0f, localPos.method_4945() / 16.0f, localPos.method_4947() / 16.0f, 1.0f);
                posVector.method_22674(poseMatrix);
                vertexBuilder.method_23919(posVector.method_4953(), posVector.method_4956(), posVector.method_4957(), (float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f, quadUvs.field_1343 + uOffset, quadUvs.field_1342 + vOffset, class_4608.field_21444, combinedLight, 0.0f, 1.0f, 0.0f);
            }
        }
    }
}

