/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.api.taglock;

import com.favouriteless.enchanted.api.taglock.IBedTaglock;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2587;
import net.minecraft.class_3218;

public class BedTaglockSavedData
extends class_18 {
    private static final String NAME = "enchanted_bed_taglocks";
    private final Map<class_2338, IBedTaglock> entries = new HashMap<class_2338, IBedTaglock>();

    public IBedTaglock getEntry(class_2587 bed) {
        return this.getEntry(bed.method_11016());
    }

    public static BedTaglockSavedData get(class_1937 level) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            return (BedTaglockSavedData)serverLevel.method_17983().method_17924(BedTaglockSavedData::load, BedTaglockSavedData::new, NAME);
        }
        throw new RuntimeException("Game attempted to load serverside taglock (bed) data from a clientside world.");
    }

    private IBedTaglock getEntry(class_2338 pos) {
        return this.entries.computeIfAbsent(pos, _pos -> new BedTaglockImpl());
    }

    private static BedTaglockSavedData load(class_2487 nbt) {
        BedTaglockSavedData data = new BedTaglockSavedData();
        class_2499 entryList = nbt.method_10554("entryList", 10);
        for (class_2520 e : entryList) {
            class_2487 entryNbt = (class_2487)e;
            data.getEntry(class_2338.method_10092((long)entryNbt.method_10537("pos"))).deserialize(entryNbt);
        }
        return data;
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2499 list = new class_2499();
        for (Map.Entry<class_2338, IBedTaglock> entry : this.entries.entrySet()) {
            IBedTaglock value = entry.getValue();
            if (value.getUUID() == null) continue;
            class_2487 entryNbt = (class_2487)entry.getValue().serialize();
            entryNbt.method_10544("pos", entry.getKey().method_10063());
        }
        nbt.method_10566("entryList", (class_2520)list);
        return nbt;
    }

    private static class BedTaglockImpl
    implements IBedTaglock {
        private UUID uuid = null;
        private String name = null;

        private BedTaglockImpl() {
        }

        @Override
        public class_2487 serialize() {
            class_2487 nbt = new class_2487();
            nbt.method_25927("uuid", this.uuid);
            nbt.method_10582("name", this.name);
            return nbt;
        }

        @Override
        public void deserialize(class_2487 nbt) {
            this.uuid = nbt.method_25926("uuid");
            this.name = nbt.method_10558("name");
        }

        @Override
        public UUID getUUID() {
            return this.uuid;
        }

        @Override
        public void setUUID(UUID uuid) {
            this.uuid = uuid;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }
    }
}

