/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.api.rites;

import com.favouriteless.enchanted.Enchanted;
import com.favouriteless.enchanted.api.rites.AbstractRite;
import com.favouriteless.enchanted.common.init.registry.RiteTypes;
import com.favouriteless.enchanted.common.rites.RiteType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public class RiteSavedData
extends class_18 {
    private static final String NAME = "enchanted_rites";
    public final List<AbstractRite> ACTIVE_RITES = new ArrayList<AbstractRite>();
    public final class_3218 level;

    public RiteSavedData(class_3218 world) {
        this.level = world;
    }

    public static RiteSavedData get(class_1937 level) {
        if (level instanceof class_3218) {
            class_3218 overworld = level.method_8503().method_3847(class_1937.field_25179);
            class_26 storage = overworld.method_17983();
            return (RiteSavedData)storage.method_17924(nbt -> RiteSavedData.load(overworld, nbt), () -> new RiteSavedData(overworld), NAME);
        }
        throw new RuntimeException("Game attempted to load serverside rite data from a clientside world.");
    }

    public static RiteSavedData load(class_3218 level, class_2487 nbt) {
        RiteSavedData data = new RiteSavedData(level);
        class_2499 riteList = nbt.method_10554("riteList", 10);
        for (int i = 0; i < riteList.size(); ++i) {
            class_2487 riteNbt = riteList.method_10602(i);
            String typeString = riteNbt.method_10558("type");
            RiteType<?> type = RiteTypes.get(new class_2960(typeString));
            if (type != null) {
                Object rite = type.create();
                if (((AbstractRite)rite).load(riteNbt, (class_1937)data.level)) {
                    data.ACTIVE_RITES.add((AbstractRite)rite);
                    continue;
                }
                Enchanted.LOG.error("Failed to load rite of type" + typeString);
                continue;
            }
            Enchanted.LOG.error(String.format("Invalid rite type %s found in world save. Rite will not be loaded.", typeString));
        }
        return data;
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2499 riteList = new class_2499();
        for (AbstractRite rite : this.ACTIVE_RITES) {
            if (rite.isRemoved || rite.isStarting()) continue;
            riteList.add((Object)rite.save());
        }
        nbt.method_10566("riteList", (class_2520)riteList);
        return nbt;
    }
}

