/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.api.rites;

import com.favouriteless.enchanted.api.power.IPowerProvider;
import com.favouriteless.enchanted.api.power.PowerHelper;
import com.favouriteless.enchanted.common.blocks.entity.ChalkGoldBlockEntity;
import com.favouriteless.enchanted.common.init.registry.EnchantedItems;
import com.favouriteless.enchanted.common.rites.CirclePart;
import com.favouriteless.enchanted.common.rites.RiteType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;

public abstract class AbstractRite {
    private final RiteType<?> riteType;
    public final HashMap<CirclePart, class_2248> CIRCLES_REQUIRED = new HashMap();
    public final HashMap<class_1299<?>, Integer> ENTITIES_REQUIRED = new HashMap();
    public final HashMap<class_1792, Integer> ITEMS_REQUIRED = new HashMap();
    public final int POWER;
    public final int POWER_TICK;
    protected final List<class_1799> itemsConsumed = new ArrayList<class_1799>();
    private class_3218 level;
    private class_2338 pos;
    private UUID casterUUID;
    private UUID targetUUID;
    private class_1297 targetEntity;
    private boolean isStarting = false;
    protected long ticks = 0L;
    private boolean isAttached = true;
    private ChalkGoldBlockEntity chalk = null;
    public boolean isRemoved = false;

    public AbstractRite(RiteType<?> type, class_3218 level, class_2338 pos, UUID casterUUID, int power, int powerTick) {
        class_2586 class_25862;
        this.level = level;
        this.pos = pos;
        this.riteType = type;
        this.casterUUID = casterUUID;
        this.POWER = power;
        this.POWER_TICK = powerTick;
        if (level != null && pos != null && (class_25862 = level.method_8321(pos)) instanceof ChalkGoldBlockEntity) {
            ChalkGoldBlockEntity chalk;
            this.chalk = chalk = (ChalkGoldBlockEntity)class_25862;
        }
    }

    protected void execute() {
    }

    protected void onTick() {
    }

    public void onStopExecuting() {
    }

    public void stopExecuting() {
        this.onStopExecuting();
        this.detatchFromChalk();
        this.isStarting = false;
        this.isRemoved = true;
    }

    public void cancel() {
        this.detatchFromChalk();
        this.isStarting = false;
        this.isRemoved = true;
        while (!this.itemsConsumed.isEmpty()) {
            class_1799 stack = this.itemsConsumed.get(0);
            class_1542 entity = new class_1542((class_1937)this.level, (double)this.pos.method_10263() + 0.5, (double)this.pos.method_10264() + 0.5, (double)this.pos.method_10260() + 0.5, stack);
            this.level.method_8649((class_1297)entity);
            this.itemsConsumed.remove(stack);
        }
        this.level.method_8396(null, this.pos, class_3417.field_14708, class_3419.field_15250, 1.0f, 1.0f);
        class_3222 player = this.level.method_8503().method_3760().method_14602(this.casterUUID);
        if (player != null) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Rite failed.").method_27692(class_124.field_1061), false);
        }
        for (int i = 0; i < 25; ++i) {
            double dx = (double)this.pos.method_10263() + Math.random();
            double dy = (double)this.pos.method_10264() + Math.random();
            double dz = (double)this.pos.method_10260() + Math.random();
            this.level.method_14199((class_2394)new class_2390(new class_1160(0.99607843f, 0.36862746f, 0.36862746f), 1.0f), dx, dy, dz, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected boolean checkAdditional() {
        return true;
    }

    protected void saveAdditional(class_2487 nbt) {
    }

    protected boolean loadAdditional(class_2487 nbt, class_1937 level) {
        return true;
    }

    protected class_1297 tryFindTargetEntity() {
        class_3222 target = this.level.method_8503().method_3760().method_14602(this.targetUUID);
        if (target != null) {
            return target;
        }
        for (class_3218 serverWorld : this.level.method_8503().method_3738()) {
            target = serverWorld.method_14190(this.targetUUID);
            if (target == null) continue;
            this.targetEntity = target;
            return target;
        }
        return null;
    }

    public class_3222 tryFindCaster() {
        return this.level.method_8503().method_3760().method_14602(this.getCasterUUID());
    }

    public class_3218 getLevel() {
        return this.level;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public UUID getCasterUUID() {
        return this.casterUUID;
    }

    public UUID getTargetUUID() {
        return this.targetUUID;
    }

    protected void setTargetUUID(UUID uuid) {
        this.targetUUID = uuid;
    }

    public class_1297 getTargetEntity() {
        return this.targetEntity;
    }

    protected void setTargetEntity(class_1297 entity) {
        this.targetEntity = entity;
        if (entity != null) {
            this.targetUUID = entity.method_5667();
        }
    }

    public class_2487 save() {
        class_2487 nbt = new class_2487();
        nbt.method_10582("type", this.getType().getId().toString());
        nbt.method_10582("dimension", this.level.method_27983().method_29177().toString());
        nbt.method_10569("x", this.pos.method_10263());
        nbt.method_10569("y", this.pos.method_10264());
        nbt.method_10569("z", this.pos.method_10260());
        nbt.method_25927("caster", this.casterUUID);
        if (this.targetUUID != null) {
            nbt.method_25927("target", this.targetUUID);
        }
        nbt.method_10544("ticks", this.ticks);
        nbt.method_10556("isAttached", this.isAttached);
        this.saveAdditional(nbt);
        return nbt;
    }

    public boolean load(class_2487 nbt, class_1937 level) {
        this.level = level.method_8503().method_3847(class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(nbt.method_10558("dimension"))));
        this.pos = new class_2338(nbt.method_10550("x"), nbt.method_10550("y"), nbt.method_10550("z"));
        this.casterUUID = nbt.method_25926("caster");
        this.ticks = nbt.method_10537("ticks");
        this.isAttached = nbt.method_10577("isAttached");
        if (nbt.method_10545("target")) {
            this.targetUUID = nbt.method_25926("target");
        }
        return this.loadAdditional(nbt, level);
    }

    protected boolean tryConsumePower(int amount) {
        if (this.level != null) {
            if (amount > 0) {
                IPowerProvider provider;
                class_2586 be = this.level.method_8321(this.pos);
                if (be instanceof ChalkGoldBlockEntity && (provider = PowerHelper.tryGetPowerProvider((class_1937)this.level, ((ChalkGoldBlockEntity)be).getPosHolder())) != null) {
                    return provider.tryConsumePower(amount);
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public RiteType<?> getType() {
        return this.riteType;
    }

    public void tick() {
        if (this.level != null) {
            if (this.isAttached && this.chalk == null) {
                class_2586 be = this.level.method_8321(this.pos);
                if (be instanceof ChalkGoldBlockEntity) {
                    ChalkGoldBlockEntity chalk;
                    this.chalk = chalk = (ChalkGoldBlockEntity)be;
                    chalk.setRite(this);
                } else {
                    this.stopExecuting();
                }
            }
            ++this.ticks;
            if (this.isStarting && !this.isRemoved) {
                if (this.ticks % 20L == 0L) {
                    List allEntities = this.level.method_8335(null, new class_238(this.pos.method_10069(-7, 0, -7), this.pos.method_10069(7, 1, 7)));
                    boolean hasItem = false;
                    for (class_1297 entity : allEntities) {
                        class_1542 itemEntity;
                        if (!(entity instanceof class_1542) || !this.ITEMS_REQUIRED.containsKey((itemEntity = (class_1542)entity).method_6983().method_7909())) continue;
                        this.consumeItem(itemEntity);
                        hasItem = true;
                        break;
                    }
                    boolean hasEntity = false;
                    if (!hasItem) {
                        if (this.ITEMS_REQUIRED.isEmpty()) {
                            for (class_1297 entity : allEntities) {
                                if (!this.ENTITIES_REQUIRED.containsKey(entity.method_5864())) continue;
                                hasEntity = true;
                                this.consumeEntity(entity);
                                break;
                            }
                        } else {
                            this.cancel();
                            return;
                        }
                        if (!hasEntity) {
                            if (this.ENTITIES_REQUIRED.isEmpty()) {
                                this.startExecuting();
                            } else {
                                this.cancel();
                            }
                        }
                    }
                }
            } else if (!this.isRemoved) {
                if (this.tryConsumePower(this.POWER_TICK)) {
                    this.onTick();
                } else {
                    this.stopExecuting();
                }
            }
        }
    }

    protected void startExecuting() {
        if (this.tryConsumePower(this.POWER) && this.checkAdditional()) {
            this.isStarting = false;
            this.ticks = 0L;
            this.execute();
        } else {
            this.cancel();
        }
    }

    protected void detatchFromChalk() {
        ChalkGoldBlockEntity chalk;
        class_2586 be = this.level.method_8321(this.pos);
        if (be instanceof ChalkGoldBlockEntity && (chalk = (ChalkGoldBlockEntity)be).getRite() == this) {
            chalk.clearRite();
        }
        this.isAttached = false;
    }

    protected void consumeItem(class_1542 entity) {
        entity.method_6989();
        class_1799 stack = entity.method_6983();
        class_1792 item = stack.method_7909();
        int amountNeeded = this.ITEMS_REQUIRED.get(stack.method_7909());
        if (amountNeeded >= stack.method_7947()) {
            this.ITEMS_REQUIRED.put(item, this.ITEMS_REQUIRED.get(item) - stack.method_7947());
            if (this.ITEMS_REQUIRED.get(item) <= 0) {
                this.ITEMS_REQUIRED.remove(item);
            }
            if (item != EnchantedItems.ATTUNED_STONE_CHARGED.get()) {
                this.itemsConsumed.add(stack);
            } else {
                class_1542 itemEntity = new class_1542((class_1937)this.level, entity.method_19538().method_10216(), entity.method_19538().method_10214(), entity.method_19538().method_10215(), new class_1799((class_1935)EnchantedItems.ATTUNED_STONE.get(), stack.method_7947()));
                this.level.method_8649((class_1297)itemEntity);
            }
            entity.method_31472();
        } else {
            this.ITEMS_REQUIRED.remove(item);
            class_1799 consumed = new class_1799((class_1935)item, amountNeeded);
            consumed.method_7980(stack.method_7969());
            this.itemsConsumed.add(consumed);
            stack.method_7934(amountNeeded);
            entity.method_6979(stack);
        }
        if (item == EnchantedItems.TAGLOCK_FILLED.get() && stack.method_7985()) {
            this.targetUUID = stack.method_7969().method_25926("entity");
            this.targetEntity = this.tryFindTargetEntity();
        }
        this.playConsumeEffects(entity);
        entity.method_6988();
    }

    protected void consumeItemNoRequirement(class_1542 entity) {
        entity.method_6989();
        this.playConsumeEffects(entity);
        this.itemsConsumed.add(entity.method_6983());
        entity.method_31472();
    }

    protected void playConsumeEffects(class_1542 entity) {
        this.level.method_8396(null, entity.method_24515(), class_3417.field_15219, class_3419.field_15250, 1.0f, 1.0f);
        for (int i = 0; i < 5; ++i) {
            double dx = entity.method_19538().field_1352 - 0.15 + Math.random() * 0.3;
            double dy = entity.method_19538().field_1351 + Math.random() * 0.3;
            double dz = entity.method_19538().field_1350 - 0.15 + Math.random() * 0.3;
            this.level.method_14199((class_2394)class_2398.field_11251, dx, dy, dz, 5, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected void consumeEntity(class_1297 entity) {
        int newAmount = this.ENTITIES_REQUIRED.get(entity.method_5864()) - 1;
        if (newAmount > 0) {
            this.ENTITIES_REQUIRED.put(entity.method_5864(), newAmount);
        } else {
            this.ENTITIES_REQUIRED.remove(entity.method_5864());
        }
        entity.method_31472();
        this.level.method_8396(null, entity.method_24515(), class_3417.field_15219, class_3419.field_15250, 1.0f, 1.0f);
        for (int i = 0; i < 10; ++i) {
            double dx = entity.method_19538().field_1352 - (double)(entity.method_17681() / 2.0f) + Math.random() * (double)entity.method_17681();
            double dy = entity.method_19538().field_1351 + Math.random() * (double)entity.method_17682();
            double dz = entity.method_19538().field_1350 - (double)(entity.method_17681() / 2.0f) + Math.random() * (double)entity.method_17681();
            this.level.method_14199((class_2394)class_2398.field_11251, dx, dy, dz, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public boolean is(HashMap<CirclePart, class_2248> circles, HashMap<class_1299<?>, Integer> entities, HashMap<class_1792, Integer> items) {
        return this.CIRCLES_REQUIRED.equals(circles) && this.ENTITIES_REQUIRED.equals(entities) && this.ITEMS_REQUIRED.equals(items);
    }

    public int differenceAt(class_1937 world, class_2338 pos) {
        for (CirclePart circlePart : this.CIRCLES_REQUIRED.keySet()) {
            if (circlePart.match(world, pos, this.CIRCLES_REQUIRED.get((Object)circlePart))) continue;
            return -1;
        }
        List allEntities = world.method_8335(null, new class_238(pos.method_10069(-7, 0, -7), pos.method_10069(7, 1, 7)));
        HashMap<class_1792, Integer> items = new HashMap<class_1792, Integer>();
        HashMap<class_1299, Integer> entities = new HashMap<class_1299, Integer>();
        for (class_1297 entity : allEntities) {
            if (entity instanceof class_1542) {
                class_1542 class_15422 = (class_1542)entity;
                class_1799 itemStack = class_15422.method_6983();
                if (!items.containsKey(itemStack.method_7909())) {
                    items.put(itemStack.method_7909(), itemStack.method_7947());
                    continue;
                }
                items.put(itemStack.method_7909(), (Integer)items.get(itemStack.method_7909()) + itemStack.method_7947());
                continue;
            }
            if (!entities.containsKey(entity.method_5864())) {
                entities.put(entity.method_5864(), 1);
                continue;
            }
            entities.put(entity.method_5864(), (Integer)entities.get(entity.method_5864()) + 1);
        }
        int diff = 0;
        if (!this.ITEMS_REQUIRED.isEmpty()) {
            for (class_1792 class_17922 : this.ITEMS_REQUIRED.keySet()) {
                if (items.containsKey(class_17922) && (Integer)items.get(class_17922) >= this.ITEMS_REQUIRED.get(class_17922)) continue;
                return -1;
            }
            for (class_1792 class_17923 : items.keySet()) {
                if (this.ITEMS_REQUIRED.containsKey(class_17923)) continue;
                diff += ((Integer)items.get(class_17923)).intValue();
            }
        }
        if (!this.ENTITIES_REQUIRED.isEmpty()) {
            for (class_1299 class_12992 : this.ENTITIES_REQUIRED.keySet()) {
                if (entities.containsKey(class_12992) && (Integer)entities.get(class_12992) >= this.ENTITIES_REQUIRED.get(class_12992)) continue;
                return -1;
            }
            for (class_1299 class_12993 : entities.keySet()) {
                if (this.ENTITIES_REQUIRED.containsKey(class_12993)) continue;
                diff += ((Integer)entities.get(class_12993)).intValue();
            }
        }
        return diff;
    }

    public void start() {
        this.isStarting = true;
    }

    protected void spawnMagicParticles() {
        for (int i = 0; i < 25; ++i) {
            double dx = (double)this.pos.method_10263() - 1.0 + Math.random() * 3.0;
            double dy = (double)this.pos.method_10264() + Math.random() * 2.0;
            double dz = (double)this.pos.method_10260() - 1.0 + Math.random() * 3.0;
            this.level.method_14199((class_2394)class_2398.field_11249, dx, dy, dz, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public boolean isStarting() {
        return this.isStarting;
    }

    public boolean hasCircle(CirclePart part, class_2248 block) {
        return this.CIRCLES_REQUIRED.containsKey((Object)part) && this.CIRCLES_REQUIRED.get((Object)part) == block;
    }

    protected void replaceItem(class_1542 entity, class_1799 ... newItems) {
        if (!entity.field_6002.field_9236) {
            for (class_1799 stack : newItems) {
                class_1542 newEntity = new class_1542(entity.field_6002, entity.method_19538().method_10216(), entity.method_19538().method_10214(), entity.method_19538().method_10215(), stack);
                entity.field_6002.method_8649((class_1297)newEntity);
            }
            entity.method_31472();
        }
    }
}

