/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.api.rites;

import com.favouriteless.enchanted.Enchanted;
import com.favouriteless.enchanted.api.curses.Curse;
import com.favouriteless.enchanted.api.curses.CurseSavedData;
import com.favouriteless.enchanted.api.familiars.FamiliarSavedData;
import com.favouriteless.enchanted.api.familiars.IFamiliarCapability;
import com.favouriteless.enchanted.api.rites.AbstractRite;
import com.favouriteless.enchanted.common.curses.CurseManager;
import com.favouriteless.enchanted.common.curses.CurseType;
import com.favouriteless.enchanted.common.init.registry.EnchantedParticleTypes;
import com.favouriteless.enchanted.common.init.registry.EnchantedSoundEvents;
import com.favouriteless.enchanted.common.init.registry.FamiliarTypes;
import com.favouriteless.enchanted.common.rites.RiteType;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_3218;
import net.minecraft.class_3419;

public abstract class AbstractRemoveCurseRite
extends AbstractRite {
    public static final int RAISE = 300;
    public static final int START_SOUND = 190;
    private final CurseType<?> curseType;

    public AbstractRemoveCurseRite(RiteType<?> type, class_3218 level, class_2338 pos, UUID caster, int power, int powerTick, CurseType<?> curseType) {
        super(type, level, pos, caster, power, powerTick);
        this.curseType = curseType;
    }

    @Override
    protected void execute() {
        if (this.getTargetUUID() == null) {
            this.cancel();
        } else {
            class_2338 pos = this.getPos();
            this.getLevel().method_14199((class_2394)EnchantedParticleTypes.REMOVE_CURSE_SEED.get(), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 2.5, (double)pos.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void onTick() {
        class_3218 level = this.getLevel();
        class_2338 pos = this.getPos();
        if (this.ticks == 190L) {
            level.method_8396(null, pos, EnchantedSoundEvents.REMOVE_CURSE.get(), class_3419.field_15250, 1.0f, 1.0f);
        } else if (this.ticks == 300L) {
            List<Curse> curses = CurseSavedData.get((class_1937)level).entries.get(this.getTargetUUID());
            if (curses != null) {
                int casterLevel = 0;
                FamiliarSavedData data = FamiliarSavedData.get((class_1937)level);
                IFamiliarCapability.IFamiliarEntry familiarEntry = data.getEntry(this.getCasterUUID());
                if (!familiarEntry.isDismissed() && familiarEntry.getType() == FamiliarTypes.CAT) {
                    ++casterLevel;
                }
                for (Curse curse : curses) {
                    if (curse.getType() != this.curseType) continue;
                    int diff = casterLevel - curse.getLevel();
                    double cureChance = 1.0 + (double)diff * 0.2;
                    if (Enchanted.RANDOM.nextDouble() < cureChance) {
                        CurseManager.removeCurse(level, curse);
                        break;
                    }
                    if (curse.getLevel() >= 2) break;
                    curse.setLevel(curse.getLevel() + 1);
                    break;
                }
            }
            this.stopExecuting();
        }
    }
}

