/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.api.familiars;

import com.favouriteless.enchanted.api.familiars.FamiliarType;
import com.favouriteless.enchanted.api.familiars.IFamiliarCapability;
import com.favouriteless.enchanted.common.init.registry.FamiliarTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1321;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public class FamiliarSavedData
extends class_18 {
    private static final String NAME = "enchanted_familiars";
    private final Map<UUID, IFamiliarCapability.IFamiliarEntry> entries = new HashMap<UUID, IFamiliarCapability.IFamiliarEntry>();

    public IFamiliarCapability.IFamiliarEntry getEntry(UUID uuid) {
        return this.entries.get(uuid);
    }

    public void setFamiliar(UUID owner, FamiliarType<?, ?> type, class_1321 familiar) {
        this.entries.put(owner, new FamiliarEntry(type, familiar));
    }

    public static FamiliarSavedData get(class_1937 level) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            return (FamiliarSavedData)serverLevel.method_17983().method_17924(FamiliarSavedData::load, FamiliarSavedData::new, NAME);
        }
        throw new RuntimeException("Game attempted to load serverside familiar data from a clientside world.");
    }

    private static FamiliarSavedData load(class_2487 nbt) {
        FamiliarSavedData data = new FamiliarSavedData();
        for (String key : nbt.method_10541()) {
            class_2487 tag = nbt.method_10562(key);
            FamiliarEntry entry = new FamiliarEntry(FamiliarTypes.get(new class_2960(tag.method_10558("type"))), tag.method_25926("uuid"), tag.method_10562("nbt"), tag.method_10577("isDismissed"));
            data.entries.put(UUID.fromString(key), entry);
        }
        return data;
    }

    @NotNull
    public class_2487 method_75(@NotNull class_2487 nbt) {
        for (UUID uuid : this.entries.keySet()) {
            class_2487 tag = new class_2487();
            IFamiliarCapability.IFamiliarEntry entry = this.entries.get(uuid);
            if (entry == null) continue;
            tag.method_25927("uuid", entry.getUUID());
            tag.method_10582("type", entry.getType().getId().toString());
            tag.method_10566("nbt", (class_2520)entry.getNbt());
            tag.method_10556("isDismissed", entry.isDismissed());
            nbt.method_10566(uuid.toString(), (class_2520)tag);
        }
        return nbt;
    }

    public static class FamiliarEntry
    implements IFamiliarCapability.IFamiliarEntry {
        private final FamiliarType<?, ?> type;
        private UUID uuid;
        private class_2487 nbt;
        private boolean isDismissed = false;

        private FamiliarEntry(FamiliarType<?, ?> type, class_1321 familiar) {
            this.uuid = familiar.method_5667();
            this.type = type;
            this.setNbt(familiar.method_5647(new class_2487()));
        }

        private FamiliarEntry(FamiliarType<?, ?> type, UUID uuid, class_2487 nbt, boolean isDismissed) {
            this.uuid = uuid;
            this.type = type;
            this.isDismissed = isDismissed;
            this.setNbt(nbt);
        }

        @Override
        public UUID getUUID() {
            return this.uuid;
        }

        @Override
        public void setUUID(UUID uuid) {
            this.uuid = uuid;
        }

        @Override
        public FamiliarType<?, ?> getType() {
            return this.type;
        }

        @Override
        public class_2487 getNbt() {
            return this.nbt;
        }

        @Override
        public void setNbt(class_2487 nbt) {
            this.nbt = nbt.method_10553();
            this.nbt.method_10551("UUID");
        }

        @Override
        public boolean isDismissed() {
            return this.isDismissed;
        }

        @Override
        public void setDismissed(boolean value) {
            this.isDismissed = value;
        }
    }
}

