/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.api.curses;

import com.favouriteless.enchanted.api.curses.Curse;
import com.favouriteless.enchanted.common.curses.CurseType;
import net.minecraft.class_2487;

public abstract class RandomCurse
extends Curse {
    private final int minTime;
    private final int maxTime;
    private final double chance;
    private long lastUseTick = 0L;

    public RandomCurse(CurseType<?> type, int minTime, int maxTime) {
        super(type);
        this.minTime = minTime;
        this.maxTime = maxTime;
        this.chance = 1.0 / (double)((maxTime - minTime) * 20);
    }

    @Override
    protected void onTick() {
        long ticksSince = this.ticks - this.lastUseTick;
        if (ticksSince > (long)this.maxTime * 20L) {
            this.lastUseTick = this.ticks;
            this.execute();
        } else if (ticksSince > (long)this.minTime * 20L && Math.random() < this.chance) {
            this.lastUseTick = this.ticks;
            this.execute();
        }
    }

    protected abstract void execute();

    @Override
    protected void saveAdditional(class_2487 nbt) {
        nbt.method_10544("lastUse", this.lastUseTick);
    }

    @Override
    protected void loadAdditional(class_2487 nbt) {
        this.lastUseTick = nbt.method_10537("lastUse");
    }
}

