/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.enchanted.api.curses;

import com.favouriteless.enchanted.Enchanted;
import com.favouriteless.enchanted.api.curses.Curse;
import com.favouriteless.enchanted.common.init.registry.CurseTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public class CurseSavedData
extends class_18 {
    private static final String NAME = "enchanted_curses";
    public final Map<UUID, List<Curse>> entries = new HashMap<UUID, List<Curse>>();

    public List<Curse> getEntry(class_1657 player) {
        return this.getEntry(player.method_5667());
    }

    public static CurseSavedData get(class_1937 level) {
        if (level instanceof class_3218) {
            return (CurseSavedData)level.method_8503().method_3847(class_1937.field_25179).method_17983().method_17924(CurseSavedData::load, CurseSavedData::new, NAME);
        }
        throw new RuntimeException("Game attempted to load serverside curse data from a clientside world.");
    }

    private List<Curse> getEntry(UUID uuid) {
        return this.entries.computeIfAbsent(uuid, _uuid -> new ArrayList());
    }

    public static CurseSavedData load(class_2487 nbt) {
        CurseSavedData data = new CurseSavedData();
        for (String key : nbt.method_10541()) {
            class_2487 playerTag = (class_2487)nbt.method_10580(key);
            ArrayList<Curse> curseList = new ArrayList<Curse>();
            UUID uuid = playerTag.method_25926("uuid");
            class_2499 listNBT = playerTag.method_10554("curses", 10);
            for (class_2520 tag : listNBT) {
                class_2487 curseTag = (class_2487)tag;
                Curse curse = CurseTypes.getInstance(new class_2960(curseTag.method_10558("type")));
                if (curse != null) {
                    curse.load(curseTag);
                    curseList.add(curse);
                    continue;
                }
                Enchanted.LOG.info("Found saved Curse with invalid type, skipping.");
            }
            data.entries.put(uuid, curseList);
        }
        return data;
    }

    public class_2487 method_75(class_2487 nbt) {
        UUID uuid;
        List<Curse> curses;
        int i = 0;
        Iterator<UUID> iterator = this.entries.keySet().iterator();
        while (iterator.hasNext() && !(curses = this.entries.get(uuid = iterator.next())).isEmpty()) {
            class_2487 saveTag = new class_2487();
            class_2499 curseList = new class_2499();
            for (Curse curse : curses) {
                class_2487 curseTag = new class_2487();
                curse.save(curseTag);
                curseList.add((Object)curseTag);
            }
            saveTag.method_25927("uuid", uuid);
            saveTag.method_10566("curses", (class_2520)curseList);
            nbt.method_10566(String.valueOf(i++), (class_2520)saveTag);
        }
        return nbt;
    }
}

